/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public class BOMReader
extends Reader {
    private static final byte[] UTF_32_BIG_ENDIAN = new byte[]{0, 0, -2, -1};
    private static final byte[] UTF_32_LITTLE_ENDIAN = new byte[]{-1, -2, 0, 0};
    private static final byte[] UTF_16_BIG_ENDIAN = new byte[]{-2, -1};
    private static final byte[] UTF_16_LITTLE_ENDIAN = new byte[]{-1, -2};
    private static final byte[] UTF_8 = new byte[]{-17, -69, -65};
    private InputStreamReader internalReader;

    public BOMReader(InputStream in) throws IOException {
        PushbackInputStream stream = new PushbackInputStream(in, 4);
        byte[] bom = new byte[4];
        int count = stream.read(bom);
        String charsetName = null;
        if (count > 0) {
            charsetName = this.getCharset(bom, stream);
        }
        if (charsetName == null) {
            this.internalReader = new InputStreamReader(stream);
        } else if (Charset.isSupported(charsetName)) {
            Charset charset = Charset.forName(charsetName);
            this.internalReader = new InputStreamReader((InputStream)stream, charset);
        } else {
            throw new IOException("Charset '" + charsetName + "' is not supported");
        }
    }

    private String getCharset(byte[] bom, PushbackInputStream in) throws IOException {
        String charset = null;
        if (this.arrayEquals(bom, UTF_32_BIG_ENDIAN)) {
            charset = "UTF-32BE";
        } else if (this.arrayEquals(bom, UTF_32_LITTLE_ENDIAN)) {
            charset = "UTF-32LE";
        } else {
            in.unread(bom[3]);
            byte[] newBom = new byte[3];
            System.arraycopy(bom, 0, newBom, 0, 3);
            bom = newBom;
            if (this.arrayEquals(bom, UTF_8)) {
                charset = "UTF-8";
            } else {
                in.unread(bom[2]);
                newBom = new byte[2];
                System.arraycopy(bom, 0, newBom, 0, 2);
                bom = newBom;
                if (this.arrayEquals(bom, UTF_16_BIG_ENDIAN)) {
                    charset = "UTF-16BE";
                } else if (this.arrayEquals(bom, UTF_16_LITTLE_ENDIAN)) {
                    charset = "UTF-16LE";
                } else {
                    in.unread(bom);
                }
            }
        }
        return charset;
    }

    private boolean arrayEquals(byte[] bom, byte[] charsetArray) {
        boolean result = true;
        for (int i = 0; i < bom.length && result; ++i) {
            result = bom[i] == charsetArray[i];
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.internalReader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.internalReader.read(cbuf, off, len);
    }
}

