/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.crypto.impl;

import ch.e2e.crypto.impl.EncryptBase;
import ch.e2e.crypto.impl.Logging;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class Encrypt01
extends EncryptBase
implements Logging {
    public static final String HEADER_STRING = "e2ecrypt01";
    public static final byte[] HEADER = new byte[]{101, 50, 101, 99, 114, 121, 112, 116, 48, 49};
    public static final int HEADER_LENGTH = HEADER.length;
    private static final String ALGORITHM = "Blowfish/ECB/PKCS5Padding";
    private static final byte[] raw = new byte[]{-106, -14, -64, 22, 58, -119, -99, -18, 123, 71, -113, -81, -19, 14, -46, 7};
    private Cipher ecipher = Encrypt01.init(1);

    public static Cipher init(int encryptMode) {
        Cipher cipher = null;
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "Blowfish");
            cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(encryptMode, skeySpec);
        }
        catch (InvalidKeyException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.severe("Disable encryption");
        }
        catch (NoSuchAlgorithmException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.severe("Disable encryption");
        }
        catch (NoSuchPaddingException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.severe("Disable encryption");
        }
        return cipher;
    }

    @Override
    public OutputStream getCipherOutputStream(OutputStream out) throws IOException {
        if (this.ecipher != null) {
            out.write(HEADER);
            out = new CipherOutputStream(out, this.ecipher);
        }
        return out;
    }
}

