/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;

public class InfiniteProgressPanel
extends JComponent
implements ActionListener {
    private static final int DEFAULT_NUMBER_OF_BARS = 12;
    private int numBars = 12;
    private double dScale = 1.2;
    private Area[] bars;
    private Rectangle barsBounds = null;
    private Rectangle barsScreenBounds = null;
    private AffineTransform centerAndScaleTransform = null;
    private Timer timer = new Timer(62, this);
    private Color[] colors = new Color[this.numBars * 2];
    private int colorOffset = 0;
    private boolean tempHide = false;

    public InfiniteProgressPanel() {
        this(1.0);
    }

    public InfiniteProgressPanel(double d) {
        this.bars = InfiniteProgressPanel.buildTicker(this.numBars, d);
        this.barsBounds = new Rectangle();
        for (Area area : this.bars) {
            this.barsBounds = this.barsBounds.union(area.getBounds());
        }
        for (int i = 0; i < this.bars.length; ++i) {
            int n = 224 - 128 / (i + 1);
            this.colors[i] = new Color(n, n, n);
            this.colors[this.numBars + i] = this.colors[i];
        }
        this.setOpaque(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.colorOffset = this.colorOffset == this.numBars - 1 ? 0 : ++this.colorOffset;
        if (this.barsScreenBounds != null) {
            this.repaint(this.barsScreenBounds);
        } else {
            this.repaint();
        }
    }

    public void setVisible(boolean bl) {
        this.setOpaque(false);
        if (bl) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
        super.setVisible(bl);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.centerAndScaleTransform = new AffineTransform();
        this.centerAndScaleTransform.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        this.centerAndScaleTransform.scale(this.dScale, this.dScale);
        if (this.barsBounds != null) {
            Area area = new Area(this.barsBounds);
            area.transform(this.centerAndScaleTransform);
            this.barsScreenBounds = area.getBounds();
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (!this.tempHide) {
            Rectangle rectangle = graphics.getClipBounds();
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.transform(this.centerAndScaleTransform);
            for (int i = 0; i < this.bars.length; ++i) {
                graphics2D.setColor(this.colors[i + this.colorOffset]);
                graphics2D.fill(this.bars[i]);
            }
        }
    }

    private static Area[] buildTicker(int n, double d) {
        Area[] areaArray = new Area[n];
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d2 = Math.PI * 2 / (double)n;
        for (double d3 = 0.0; d3 < (double)n; d3 += 1.0) {
            Area area = InfiniteProgressPanel.buildPrimitive(d);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(double_.getX(), double_.getY());
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(2.0, -0.4);
            AffineTransform affineTransform3 = AffineTransform.getRotateInstance(-d3 * d2, double_.getX(), double_.getY());
            AffineTransform affineTransform4 = new AffineTransform();
            affineTransform4.concatenate(affineTransform);
            affineTransform4.concatenate(affineTransform2);
            area.transform(affineTransform4);
            area.transform(affineTransform3);
            areaArray[(int)d3] = area;
        }
        return areaArray;
    }

    private static Area buildPrimitive(double d) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(2.0 * d, 0.0, 4.0 * d, d);
        return new Area(double_);
    }

    public void start() {
        this.setVisible(true);
    }

    public void stop() {
        this.setVisible(false);
    }
}

