/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.model;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.event.CreateTestcaseEvent;
import ch.e2e.builder.regtest.event.DeleteTestSuiteEvent;
import ch.e2e.builder.regtest.event.ImportTestcaseEvent;
import ch.e2e.builder.regtest.event.RenameTestSuiteEvent;
import ch.e2e.builder.regtest.event.SortTestSuiteEvent;
import ch.e2e.builder.regtest.event.UseAsLibraryEvent;
import ch.e2e.builder.regtest.model.TestSuiteRootPopupMenu;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.event.EventController;
import ch.e2e.resource.ImageLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JMenuItem;

public class TestSuitePopupMenu
extends TestSuiteRootPopupMenu {
    private JMenuItem useAsLibraryItem;
    private JMenuItem renameItem;
    private JMenuItem removeItem;
    private JMenuItem importTestcaseItem;
    private JMenuItem createTestcaseItem;
    private JMenuItem sortTestSuiteItem;

    public TestSuitePopupMenu(E2EBuilderModule module) {
        super(module);
    }

    @Override
    public void setTestSuite(TreeTestSuite testSuite) {
        super.setTestSuite(testSuite);
        boolean canWrite = testSuite.canWrite();
        this.useAsLibraryItem.setEnabled(canWrite && !LibrariesRoot.isInLibraryTree(testSuite));
        this.renameItem.setEnabled(canWrite);
        this.removeItem.setEnabled(canWrite);
        this.importTestcaseItem.setEnabled(canWrite);
        this.createTestcaseItem.setEnabled(canWrite);
        this.sortTestSuiteItem.setEnabled(canWrite);
    }

    @Override
    protected void addModifyItems(E2EBuilderModule module) {
        this.addSeparator();
        this.renameItem = ComponentFactory.createMenuItem((String)"popup.menu.item.rename.testsuite", (E2EBuilderModule)module);
        this.renameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuitePopupMenu.this.renameTestsuite();
            }
        });
        this.add(this.renameItem);
        this.removeItem = ComponentFactory.createMenuItem((String)"popup.menu.item.remove.testsuite", (E2EBuilderModule)module);
        this.removeItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/remove.testsuite.icon.gif", (boolean)true));
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuitePopupMenu.this.removeTestsuite();
            }
        });
        this.add(this.removeItem);
        this.sortTestSuiteItem = ComponentFactory.createMenuItem((String)"popup.menu.item.sort.testsuite", (E2EBuilderModule)module);
        this.sortTestSuiteItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/sort.testsuite.icon.gif", (boolean)true));
        this.sortTestSuiteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuitePopupMenu.this.sortTestSuite();
            }
        });
        this.add(this.sortTestSuiteItem);
    }

    @Override
    protected void addTescasesItems(E2EBuilderModule module) {
        this.addSeparator();
        this.importTestcaseItem = ComponentFactory.createMenuItem((String)"popup.menu.item.import.testcases", (E2EBuilderModule)module);
        this.importTestcaseItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/import.testcase.icon.gif", (boolean)true));
        this.importTestcaseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuitePopupMenu.this.importTestcase();
            }
        });
        this.add(this.importTestcaseItem);
        this.createTestcaseItem = ComponentFactory.createMenuItem((String)"popup.menu.item.create.testcase", (E2EBuilderModule)module);
        this.createTestcaseItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/create.testcase.icon.gif", (boolean)true));
        this.createTestcaseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuitePopupMenu.this.createTestcase();
            }
        });
        this.add(this.createTestcaseItem);
    }

    @Override
    protected void addLibraryItems(E2EBuilderModule module) {
        super.addLibraryItems(module);
        this.useAsLibraryItem = ComponentFactory.createMenuItem((String)"popup.menu.item.library.use.as", (E2EBuilderModule)module);
        this.useAsLibraryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuitePopupMenu.this.useAsLibrary();
            }
        });
        this.add(this.useAsLibraryItem);
    }

    private void renameTestsuite() {
        EventController.fire((EventObject)new RenameTestSuiteEvent(this, this.getTestSuite()));
    }

    private void removeTestsuite() {
        EventController.fire((EventObject)new DeleteTestSuiteEvent(this, this.getTestSuite()));
    }

    private void importTestcase() {
        EventController.fire((EventObject)new ImportTestcaseEvent(this, this.getTestSuite(), 0));
    }

    private void createTestcase() {
        EventController.fire((EventObject)new CreateTestcaseEvent(this, this.getTestSuite(), 0));
    }

    private void useAsLibrary() {
        EventController.fire((EventObject)new UseAsLibraryEvent(this, this.getTestSuite()));
    }

    private void sortTestSuite() {
        EventController.fire((EventObject)new SortTestSuiteEvent(this, this.getTestSuite()));
    }
}

