/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.TextFieldOptionPane;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.io.FileUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.swing.RegexTextField;
import ch.e2e.test.options.FileOption;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileOptionPane
extends TextFieldOptionPane<File, FileOption> {
    private RegexTextField textField;
    private JLabel nameLabel;
    private FileOption option;
    private JButton browseButton;

    public FileOptionPane() {
        super(new BorderLayout());
        this.createGui();
    }

    @Override
    public File getValue() {
        String text = this.textField.getText();
        return text.isEmpty() ? null : new File(text);
    }

    @Override
    protected JTextField getTextField() {
        return this.textField;
    }

    @Override
    public void setValue(File value) {
        this.setFireOptionInputChanged(false);
        if (value == null) {
            this.textField.setText("");
        } else if (value.isAbsolute()) {
            this.textField.setText(value.getAbsolutePath());
        } else {
            this.textField.setText(FileUtilities.getRelativePath((File)value, (File)new File("")));
        }
        this.setFireOptionInputChanged(true);
    }

    @Override
    public FileOption getOption() {
        return this.option;
    }

    @Override
    public void setOption(FileOption option) {
        this.option = option;
        if (option.getName() == null) {
            this.nameLabel.setVisible(false);
        } else {
            this.nameLabel.setVisible(true);
            this.nameLabel.setText(option.getName());
        }
        super.setOption(option);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.browseButton.setEnabled(!readOnly);
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridwidth = 0;
        this.nameLabel = new JLabel();
        this.add((Component)this.nameLabel, c);
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(4, 0, 2, 7);
        Properties properties = new Properties("ch.e2e.swing.swing");
        this.textField = new RegexTextField(properties.getString("absolutepath.pattern"));
        this.add((Component)this.textField, c);
        this.textField.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                FileOptionPane.this.inputChanged();
            }
        });
        this.textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String text = FileOptionPane.this.textField.getText();
                return text.isEmpty() || new File(text).isDirectory() == FileOptionPane.this.getOption().isDirectory();
            }
        });
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 0, 2, 2);
        this.browseButton = new JButton("...");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileOptionPane.this.browse();
            }
        });
        this.add((Component)this.browseButton, c);
    }

    private void browse() {
        JFileChooser fileChooser = new JFileChooser(this.findExistingRoot(this.getValue()));
        fileChooser.setFileSelectionMode(this.option.isDirectory() ? 1 : 0);
        if (this.option.getFileExtensions().size() == 0) {
            fileChooser.setAcceptAllFileFilterUsed(true);
        } else {
            fileChooser.setAcceptAllFileFilterUsed(false);
            for (FileOption.FileExtension s : this.option.getFileExtensions().values()) {
                fileChooser.addChoosableFileFilter(new FileNameExtensionFilter(s.getDescription(), s.getExtensions()));
            }
        }
        if (fileChooser.showOpenDialog(this.findWindowParent()) == 0) {
            this.setValue(fileChooser.getSelectedFile());
            this.fireOptionInputChanged();
        }
    }

    private Component findWindowParent() {
        Container parent = this.getParent();
        while (!(parent instanceof Window)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private File findExistingRoot(File file) {
        File result;
        for (result = file; result != null && !result.exists(); result = result.getParentFile()) {
        }
        return result == null ? (this.option.getDefaultStartFolder() == null ? new File("") : this.option.getDefaultStartFolder()) : result;
    }
}

