/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.test.Testable;
import ch.e2e.util.StringTools;
import java.awt.AWTEventMulticaster;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class TestSuiteChoicePanel
extends JPanel {
    private String insertTestSuiteTemplate;
    private JRadioButton testSuite_1;
    private JRadioButton testSuite_2;
    private TitledBorder titledBorder;
    private TreeTestSuite testSuite;
    private ArrayList<String> existingNames = new ArrayList();
    private ActionListener actionListener;

    public TestSuiteChoicePanel(E2EBuilderModule module) {
        super(new GridLayout(2, 1));
        this.insertTestSuiteTemplate = module.getTranslation("create.test.suite.input.name.insert.into.testsuite");
        this.createGui();
    }

    public void setTestSuite(TreeTestSuite testSuite, boolean showTestSuiteSelection) {
        this.testSuite = testSuite;
        if (showTestSuiteSelection && testSuite != null && testSuite.getParent() != null) {
            this.testSuite_1.setText(StringTools.replaceProperty((String)this.insertTestSuiteTemplate, (String)"testsuite.name", (String)testSuite.getName()));
            this.testSuite_2.setText(StringTools.replaceProperty((String)this.insertTestSuiteTemplate, (String)"testsuite.name", (String)testSuite.getParent().getName()));
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        this.setExistingNames();
    }

    public void setLibrariesRoot(LibrariesRoot libraries) {
        this.setVisible(false);
        this.testSuite = null;
        this.existingNames.clear();
        for (TreeTestSuite library : libraries) {
            this.existingNames.add(library.getName());
        }
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(new CompoundBorder(border, this.titledBorder));
    }

    public boolean existsName(String name) {
        return this.existingNames.contains(name);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(actionListener, this.actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(actionListener, this.actionListener);
    }

    public TreeTestSuite getSelectedTestSuite() {
        return !this.isVisible() || this.testSuite_1.isSelected() ? this.testSuite : (TreeTestSuite)this.testSuite.getParent();
    }

    public int getSelectionIndex() {
        return !this.isVisible() || this.testSuite_1.isSelected() ? 0 : ((TreeTestSuite)this.testSuite.getParent()).getIndexOfTest((Testable)this.testSuite) + 1;
    }

    private void setExistingNames() {
        block4: {
            this.existingNames.clear();
            if (this.testSuite == null) break block4;
            if (!this.isVisible() || this.testSuite_1.isSelected()) {
                for (Testable testable : this.testSuite.getTestcases()) {
                    this.existingNames.add(testable.getName());
                }
            } else {
                for (Testable testable : ((TreeTestSuite)this.testSuite.getParent()).getTestcases()) {
                    this.existingNames.add(testable.getName());
                }
            }
        }
    }

    private void createGui() {
        this.titledBorder = new TitledBorder("Choose Testsuite");
        super.setBorder(this.titledBorder);
        ButtonGroup selectionGroup = new ButtonGroup();
        this.testSuite_1 = new JRadioButton("");
        this.testSuite_1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TestSuiteChoicePanel.this.setExistingNames();
                if (TestSuiteChoicePanel.this.actionListener != null) {
                    TestSuiteChoicePanel.this.actionListener.actionPerformed(new ActionEvent(this, 1001, "existingNamesChanged"));
                }
            }
        });
        this.add(this.testSuite_1);
        selectionGroup.add(this.testSuite_1);
        this.testSuite_2 = new JRadioButton("");
        this.add(this.testSuite_2);
        selectionGroup.add(this.testSuite_2);
        this.testSuite_1.setSelected(true);
    }
}

