/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.gui.TestSuiteTreeCellRenderer;
import ch.e2e.builder.regtest.model.HierarchyViewTreeModel;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.TestSelectedEvent;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class HierarchyView
extends JScrollPane {
    private HierarchyViewTreeModel model;
    private Tree tree;

    public HierarchyView(E2EBuilderModule module, TreeSelectionListener treeListener) {
        super(20, 30);
        this.createGui(module, treeListener);
    }

    public void clear() {
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tree.setEnabled(enabled);
    }

    public void testSelected(TestSelectedEvent event) {
        this.clear();
        this.model.setTests(event.getTests());
        if (event.getSelectedPaths().size() > 0) {
            TreePath path = (TreePath)event.getSelectedPaths().get(0);
            if (path.getPathCount() == 1) {
                this.tree.expandPath(path);
            } else {
                this.tree.expandPath(path.getParentPath());
            }
            boolean treeEnabled = this.tree.isEnabled();
            this.tree.setSelectionPath(path);
            this.tree.setEnabled(treeEnabled);
        }
    }

    private void createGui(E2EBuilderModule module, TreeSelectionListener treeListener) {
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.model = new HierarchyViewTreeModel(module);
        TestSuiteTreeCellRenderer renderer = new TestSuiteTreeCellRenderer(this.model);
        this.tree = new Tree((AbstractTreeModel)this.model, (TreeCellRenderer)((Object)renderer));
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(treeListener);
        this.tree.setToolTipsEnabled(true);
        this.setViewportView((Component)this.tree);
    }

    public void refresh(E2ETestcase testcase) {
        ArrayList<E2ETestcase> pathObjects = new ArrayList<E2ETestcase>();
        for (E2ETestcase parent = testcase; parent != null && !parent.equals(this.model.getRoot()); parent = parent.getParent()) {
            pathObjects.add(0, parent);
        }
        TreePath path = new TreePath(pathObjects.toArray());
        this.tree.clearSelection();
        this.tree.collapseAll(path);
        this.model.fireTreeStructureChanged(path);
        this.tree.setSelectionPath(path);
    }
}

