/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.importer;

import ch.e2e.builder.trace.importer.WSDLImport;
import ch.e2e.dom.DomUtilities;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2ETest;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.XMLCompare;
import ch.e2e.test.options.CompareFileOption;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringOption;
import java.io.File;
import org.w3c.dom.Document;

public class Wsdl2SoapTest
extends E2ETest {
    public static final String KEY = "Wsdl2SoapTest";
    public static final String KEY_OPTION_WSDL_FILE = "wsdl2soap.test.wsdl.file";
    public static final String KEY_OPTION_TESTCASES_DOCUMENT = "wsdl2soap.test.testcases.document.file";

    public void doTest() throws Exception {
        FileOption wsdlFile = (FileOption)this.getOption(KEY_OPTION_WSDL_FILE);
        Wsdl2SoapTest.assertFalse((String)"The option wsdl2soap.test.wsdl.file must be defined", (wsdlFile.getValue() == null ? 1 : 0) != 0);
        FileOption testcasesDocument = (FileOption)this.getOption(KEY_OPTION_TESTCASES_DOCUMENT);
        Wsdl2SoapTest.assertFalse((String)"The option wsdl2soap.test.testcases.document.file must be defined", (testcasesDocument.getValue() == null ? 1 : 0) != 0);
        File[] wsdlFiles = new File[]{(File)wsdlFile.getValue()};
        Document testcases = new WSDLImport.FileImportSource(wsdlFiles).createTestcasesDocument();
        DomUtilities.serialize((File)((File)testcasesDocument.getValue()), (Document)testcases, (boolean)true);
    }

    public String getRecommendedCompareType() {
        return "XMLCompare";
    }

    public void setTestFolder(File testFolder) {
        super.setTestFolder(testFolder);
        FileOption testcases = (FileOption)this.getOption(KEY_OPTION_TESTCASES_DOCUMENT);
        File defaultTestcases = new File(testFolder, "${wsdl2soap.test.wsdl.file.name}.xml");
        testcases.setDependencyString(defaultTestcases.getAbsolutePath());
        testcases.setDefaultValue((Object)defaultTestcases);
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                if (!(compare instanceof XMLCompare)) continue;
                CompareFileOption testFile = (CompareFileOption)compare.getOptions().get("xml.compare.test.file");
                File defaultTestFile = new File("${wsdl2soap.test.testcases.document.file}");
                testFile.setDependencyString("${wsdl2soap.test.testcases.document.file}");
                testFile.setDefaultValue((Object)new CompareFile(defaultTestFile));
            }
        }
    }

    public void prepareCompareType(ResultCompare compare) {
        if (compare instanceof XMLCompare) {
            CompareFileOption testFile = (CompareFileOption)compare.getOptions().get("xml.compare.test.file");
            testFile.addDependency(KEY_OPTION_TESTCASES_DOCUMENT);
            testFile.setDependencyString("${wsdl2soap.test.testcases.document.file}");
            testFile.setDefaultValue((Object)new CompareFile(new File("${wsdl2soap.test.testcases.document.file}")));
            StringOption nameOption = (StringOption)compare.getOptions().get("key.option.result.compare.name");
            String defaultName = "Compare ${wsdl2soap.test.wsdl.file.name}";
            nameOption.addDependency(KEY_OPTION_WSDL_FILE);
            nameOption.setDependencyString(defaultName);
            nameOption.setDefaultValue((Object)defaultName);
            CompareFileOption referenceFile = (CompareFileOption)compare.getOptions().get("xml.compare.reference.file");
            File defaultValue = new File(this.getReferenceFolder() == null ? new File("") : this.getReferenceFolder(), "${wsdl2soap.test.wsdl.file.name}");
            referenceFile.addDependency(KEY_OPTION_WSDL_FILE);
            referenceFile.setDependencyString(defaultValue.getAbsolutePath());
            referenceFile.setDefaultValue((Object)new CompareFile(defaultValue));
        }
    }

    public void setReferenceFolder(File referenceFolder) {
        super.setReferenceFolder(referenceFolder);
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                if (!(compare instanceof XMLCompare)) continue;
                CompareFileOption referenceFile = (CompareFileOption)compare.getOptions().get("xml.compare.reference.file");
                File defaultValue = new File(referenceFolder, "${wsdl2soap.test.wsdl.file.name}.xml");
                referenceFile.addDependency(KEY_OPTION_WSDL_FILE);
                referenceFile.setDependencyString(defaultValue.getAbsolutePath());
                referenceFile.setDefaultValue((Object)new CompareFile(defaultValue));
            }
        }
    }

    public void setSourceFolder(File sourceFolder) {
        FileOption wsdlFile = (FileOption)this.getOption(KEY_OPTION_WSDL_FILE);
        File defaultValue = new File(sourceFolder, "undefined.wsdl");
        wsdlFile.setDefaultValue((Object)defaultValue);
    }

    protected void createOptions() {
        FileOption wsdlFile = new FileOption("WSDL File", KEY_OPTION_WSDL_FILE, 0);
        wsdlFile.setRequired(true);
        wsdlFile.setDirectory(false);
        wsdlFile.addFileExtension("wsdl", "WSDL Document");
        this.addOption(KEY_OPTION_WSDL_FILE, (Option)wsdlFile);
        FileOption testcases = new FileOption("Testcases Document", KEY_OPTION_TESTCASES_DOCUMENT, 1);
        testcases.setRequired(true);
        testcases.addDependency(KEY_OPTION_WSDL_FILE);
        testcases.setDependencyString("${wsdl2soap.test.wsdl.file.name}.xml");
        testcases.setDirectory(false);
        testcases.addFileExtension("xml", "XML Document");
        this.addOption(KEY_OPTION_TESTCASES_DOCUMENT, (Option)testcases);
        StringOption nameOption = (StringOption)this.getOption("key.option.test.name");
        String defaultName = "Wsdl2Soap: ${wsdl2soap.test.wsdl.file.name}";
        nameOption.addDependency(KEY_OPTION_WSDL_FILE);
        nameOption.setDependencyString(defaultName);
        nameOption.setDefaultValue((Object)defaultName);
    }
}

