/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test.options;

import ch.e2e.gui.event.ValueChangedEvent;
import ch.e2e.gui.event.ValueChangedListener;
import ch.e2e.test.CompareFile;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;

public class CompareFileOption
extends Option<CompareFile>
implements ValueChangedListener {
    private FileOption fileOption;
    private boolean listen = true;

    public CompareFileOption(String name, int index) {
        super(name, index);
        this.fileOption = new FileOption(null, index + 1);
    }

    public CompareFileOption(String name, String key, int index) {
        super(name, key, index);
        this.fileOption = new FileOption(null, index + 1);
    }

    public CompareFileOption(String name, CompareFile defaultValue, int index) {
        super(name, defaultValue, index);
        this.fileOption = new FileOption(null, defaultValue.getFile(), index + 1);
    }

    @Override
    public boolean containsOptions() {
        return true;
    }

    @Override
    public List<Option> getOptions() {
        return Arrays.asList(this.fileOption);
    }

    @Override
    public void setValue(CompareFile value) {
        super.setValue(value);
        this.fileOption.setValue(value == null ? null : value.getFile());
    }

    @Override
    public CompareFile createValue(String valueString) {
        CompareFile result;
        int dirIndex = valueString.indexOf("|");
        if (dirIndex == -1) {
            result = new CompareFile(this.fileOption.createValue(valueString));
        } else {
            String fileString = valueString.substring(0, dirIndex);
            boolean directory = false;
            try {
                String directoryString = valueString.substring(dirIndex + 1);
                directory = Boolean.valueOf(directoryString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = new CompareFile(this.fileOption.createValue(fileString));
            result.setDirectory(directory);
        }
        return result;
    }

    public FileOption getFileOption() {
        return this.fileOption;
    }

    public void addFileExtension(String fileExtension, String description) {
        this.fileOption.addFileExtension(fileExtension, description);
    }

    @Override
    public void setInherited(boolean inherited) {
        super.setInherited(inherited);
        this.fileOption.setInherited(inherited);
    }

    @Override
    public Option<CompareFile> createCopyInstance() {
        CompareFileOption result = new CompareFileOption(this.getName(), this.getIndex());
        result.fileOption = (FileOption)this.fileOption.createCopy();
        return result;
    }

    @Override
    public CompareFile createCopyOfValue() {
        CompareFile result = null;
        if (this.getValue() != null) {
            result = new CompareFile(new File(((CompareFile)this.getValue()).getFile().getAbsolutePath()));
        }
        return result;
    }

    @Override
    public void toXml(String elementName, Element parent) {
        if (this.getValue() != null) {
            Element result = parent.getOwnerDocument().createElement(elementName);
            String filename = ((CompareFile)this.getValue()).getFile().getPath().replace("\\", "/");
            if (((CompareFile)this.getValue()).isDirectory()) {
                result.setAttribute("dir", filename);
            } else {
                result.setAttribute("file", filename);
            }
            parent.appendChild(result);
        }
    }

    public void valueChanged(ValueChangedEvent e) {
        if (this.listen) {
            // empty if block
        }
    }
}

