/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.test.AbstractResultCompare;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2EAssert;
import ch.e2e.test.E2EComparisonController;
import ch.e2e.test.E2EDiff;
import ch.e2e.test.E2EDifferenceEngine;
import ch.e2e.test.E2ETest;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.PropertiesHelper;
import ch.e2e.test.TestDocumentPreprocessor;
import ch.e2e.test.TestResult;
import ch.e2e.test.TypeFactory;
import ch.e2e.test.Utilities;
import ch.e2e.test.XMLDiffErrorDetail;
import ch.e2e.test.options.BooleanOption;
import ch.e2e.test.options.CompareFileOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.OptionGroup;
import ch.e2e.test.options.PreprocessorOption;
import ch.e2e.test.options.StringListOption;
import ch.e2e.test.options.StringOption;
import ch.e2e.transformer.TransformerLoadException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLCompare
extends AbstractResultCompare {
    public static final String KEY = "XMLCompare";
    public static final String KEY_OPTION_REFERENCE_FILE = "xml.compare.reference.file";
    public static final String KEY_OPTION_TEST_FILE = "xml.compare.test.file";
    public static final String KEY_OPTION_COMPARE_IGNORED_ATTRIBUTES = "xml.compare.ignored.attributes";
    public static final String KEY_OPTION_COMPARE_IGNORED_ELEMENTS = "xml.compare.ignored.elements";
    public static final String KEY_OPTION_COMPARE_PREPROCESSOR = "xml.compare.preprocessor";
    public static final String KEY_OPTION_COMPARE_EQUAL = "xml.compare.type";
    protected boolean namespaceAware;
    protected boolean validate;
    protected boolean schemaValidation;

    public XMLCompare() {
        try {
            this.setType(TypeFactory.getInstance().getType(KEY));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init(Element options) {
        super.init(options);
        this.checkOptions(options, this.getOwner() == null ? new HashMap() : this.getOwner().getProperties(), false);
    }

    @Override
    public void doTest(E2ETest test) throws IOException, ParserConfigurationException, SAXException, TransformerException, TransformerLoadException, XPathExpressionException {
        Document referenceDocument;
        Document testDocument;
        CompareFile referenceData = (CompareFile)this.getOptionValue(KEY_OPTION_REFERENCE_FILE, test.getRunProperties());
        CompareFile testData = (CompareFile)this.getOptionValue(KEY_OPTION_TEST_FILE, test.getRunProperties());
        File referenceFile = referenceData.getFile();
        E2ETest.assertTrue((String)("File " + referenceFile.getAbsolutePath() + " does not exists."), (boolean)referenceFile.exists());
        File testFile = testData.getFile();
        E2ETest.assertTrue((String)("File " + testFile.getAbsolutePath() + " does not exists."), (boolean)testFile.exists());
        TestDocumentPreprocessor preprocessor = (TestDocumentPreprocessor)this.getOptionValue(KEY_OPTION_COMPARE_PREPROCESSOR, test.getRunProperties());
        if (preprocessor == null || !preprocessor.isEnabled()) {
            testDocument = this.getDocument(testFile);
            referenceDocument = this.getDocument(referenceFile);
        } else {
            preprocessor.setLogFolder(testFile.getParentFile());
            testDocument = preprocessor.preprocess(this.getDocument(testFile));
            preprocessor.savePreprocessedDocument(testDocument, testFile.getName() + ".test");
            referenceDocument = preprocessor.preprocess(this.getDocument(referenceFile));
            preprocessor.savePreprocessedDocument(referenceDocument, referenceFile.getName() + ".reference");
        }
        E2EComparisonController controller = new E2EComparisonController();
        E2EDiff diff = new E2EDiff(referenceDocument, testDocument, new E2EDifferenceEngine(controller, this.getIgnoredAttributes(), this.getIgnoredElements()), referenceFile.getAbsolutePath());
        this.setEndStatus(testFile.getName(), diff);
    }

    @Override
    public void mergeOptions(Element options, Map<String, String> properties) {
        this.checkOptions(options, properties, false);
    }

    @Override
    public void setGlobalTestOptions(Element options) {
        super.setGlobalTestOptions(options);
        this.checkOptions(options, this.getOwner() == null ? new HashMap() : this.getOwner().getProperties(), true);
    }

    @Override
    public TestResult getTestResult(ErrorDetail errorDetail, boolean includeHiddenData, Map<String, String> properties) {
        TestResult result;
        if (errorDetail instanceof XMLDiffErrorDetail) {
            result = errorDetail.getTestResult();
            if (result == null) {
                File testFile = ((CompareFile)this.getOptionValue(KEY_OPTION_TEST_FILE, properties)).getFile();
                File referenceFile = ((CompareFile)this.getOptionValue(KEY_OPTION_REFERENCE_FILE, properties)).getFile();
                try {
                    result = this.getTestResult(DomUtilities.parse((File)testFile, (boolean)false, (boolean)false, (boolean)false), DomUtilities.parse((File)referenceFile, (boolean)false, (boolean)false, (boolean)false), includeHiddenData, properties);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                }
                catch (SAXException sAXException) {
                }
                catch (IOException iOException) {}
            }
        } else {
            result = super.getTestResult(errorDetail, includeHiddenData, properties);
        }
        return result;
    }

    @Override
    public TestResult getTestResult(boolean includeHiddenData, Map<String, String> properties) {
        Document testDocument = this.getTestDocument(properties);
        Document referenceDocument = this.getReferenceDocument(properties);
        return this.getTestResult(testDocument, referenceDocument, includeHiddenData, properties);
    }

    protected TestResult getTestResult(Document testDocument, Document referenceDocument, boolean includeHiddenData, Map<String, String> properties) {
        TestDocumentPreprocessor preprocessor = (TestDocumentPreprocessor)this.getOptionValue(KEY_OPTION_COMPARE_PREPROCESSOR, properties);
        if (preprocessor != null && preprocessor.isEnabled()) {
            try {
                if (testDocument != null) {
                    testDocument = preprocessor.preprocess(testDocument);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (referenceDocument != null) {
                    referenceDocument = preprocessor.preprocess(referenceDocument);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!includeHiddenData) {
            XMLCompare.removeHiddenData(referenceDocument, testDocument, this.getIgnoredElements(), this.getIgnoredAttributes());
        }
        StringWriter referenceData = new StringWriter();
        StringWriter testData = new StringWriter();
        if (referenceDocument != null) {
            try {
                DomUtilities.serialize((Writer)referenceData, (Document)referenceDocument, (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (testDocument != null) {
            try {
                DomUtilities.serialize((Writer)testData, (Document)testDocument, (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new TestResult(referenceData.toString(), testData.toString());
    }

    @Override
    public boolean hasIgnoredDifferences() {
        return true;
    }

    @Override
    public HashMap<String, Option> getIgnoredDifferences() {
        return this.getAdvancedOptions();
    }

    @Override
    public void toXml(Element parent) {
        Element options = this.optionsToXml(parent.getOwnerDocument(), "xmlCompare");
        parent.appendChild(options);
    }

    @Override
    public Element optionsToXml(boolean includeType, Document ownerDocument) {
        Element result = this.optionsToXml(ownerDocument, "options");
        if (includeType) {
            result.setAttribute("type", this.getType().getName());
        }
        return result;
    }

    protected Document getReferenceDocument(Map<String, String> properties) {
        CompareFile referenceFile = (CompareFile)this.getOptionValue(KEY_OPTION_REFERENCE_FILE, properties);
        return this.getDocument(referenceFile);
    }

    protected Document getTestDocument(Map<String, String> properties) {
        CompareFile testFile = (CompareFile)this.getOptionValue(KEY_OPTION_TEST_FILE, properties);
        return this.getDocument(testFile);
    }

    private Document getDocument(CompareFile file) {
        Document document = null;
        try {
            if (file != null) {
                document = this.getDocument(file.getFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    protected Object createFileValue(Element fileElement) {
        return new CompareFile(fileElement);
    }

    protected boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    protected boolean isValidate() {
        return this.validate;
    }

    protected boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    protected void setEndStatus(String filename, E2EDiff diff) {
        Boolean equal;
        BooleanOption equalOption = (BooleanOption)this.getOptions().get(KEY_OPTION_COMPARE_EQUAL);
        Boolean bl = equal = equalOption.getValue() == null ? (Boolean)equalOption.getDefaultValue() : (Boolean)equalOption.getValue();
        if (equal == null || equal.booleanValue()) {
            this.assertXMLIdentical("XML not equal for " + filename, diff, true);
        } else {
            this.assertXMLIdentical("XML equal for " + filename, diff, false);
        }
    }

    protected void setTestFile(CompareFile testFile) {
        this.getOption(KEY_OPTION_TEST_FILE).setValue(testFile);
    }

    protected Collection<String> getIgnoredAttributes() {
        return ((StringListOption)this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ATTRIBUTES)).getStringValues();
    }

    protected Collection<String> getIgnoredElements() {
        return ((StringListOption)this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ELEMENTS)).getStringValues();
    }

    @Override
    public void test2Reference(Map<String, String> properties) throws IOException {
        try {
            FileUtilities.copyFile((File)((CompareFile)this.getOptionValue(KEY_OPTION_TEST_FILE, properties)).getFile(), (File)((CompareFile)this.getOptionValue(KEY_OPTION_REFERENCE_FILE, properties)).getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void moveReferenceData(File oldReferenceFolder, File newReferenceFolder, Map<String, String> runProperties) {
        CompareFile referenceFile = (CompareFile)this.getOptionValue(KEY_OPTION_REFERENCE_FILE, runProperties);
        if (referenceFile != null && referenceFile.getFile() != null) {
            File oldFile = referenceFile.getFile();
            String path = FileUtilities.getRelativePath((File)oldFile, (File)oldReferenceFolder);
            File newTestFile = new File(newReferenceFolder, path);
            if (newTestFile.exists()) {
                newTestFile.delete();
            } else {
                newTestFile.getParentFile().mkdirs();
            }
            if (oldFile.renameTo(newTestFile)) {
                referenceFile.setFile(newTestFile);
                this.getOption(KEY_OPTION_REFERENCE_FILE).setValue(referenceFile);
            } else {
                System.out.println("Could not move " + oldFile + " to " + newTestFile);
            }
            Utilities.deleteEmptyParents(oldFile);
        }
    }

    @Override
    public String toString() {
        return '<' + this.getKey() + '>' + (this.getName() == null ? "" : this.getName());
    }

    public void assertXMLIdentical(String msg, E2EDiff diff, boolean assertion) {
        boolean identical = diff.identical();
        XMLDiffErrorDetail errorDetail = new XMLDiffErrorDetail(diff.getReference(), diff.getMessages());
        ArrayList<ErrorDetail> errorDetails = new ArrayList<ErrorDetail>();
        errorDetails.add(errorDetail);
        E2EAssert.assertFalse(msg, errorDetails, assertion ^ identical);
    }

    @Override
    public void removeReferenceData(Map<String, String> properties) {
        Object value = this.getOptionValue(KEY_OPTION_REFERENCE_FILE, properties);
        if (value != null && ((CompareFile)value).getFile() != null) {
            File referenceFile = ((CompareFile)value).getFile();
            referenceFile.delete();
            Utilities.deleteEmptyParents(referenceFile);
        }
    }

    protected String getKey() {
        return KEY;
    }

    protected Document getDocument(File file) throws IOException, ParserConfigurationException, SAXException {
        return DomUtilities.parse((File)file, (boolean)this.validate, (boolean)this.schemaValidation, (boolean)this.namespaceAware);
    }

    @Override
    protected void createOptions() {
        this.addOption(KEY_OPTION_COMPARE_EQUAL, new BooleanOption("XML equal", "XML not equal", KEY_OPTION_COMPARE_EQUAL, true, true, 0));
        this.addOption(KEY_OPTION_TEST_FILE, new CompareFileOption("Test file", 1));
        this.addOption(KEY_OPTION_REFERENCE_FILE, new CompareFileOption("Reference file", 2));
        OptionGroup ignoreGroup = new OptionGroup("Ignores", 0);
        StringListOption ignoredElementsOption = new StringListOption("Ignored Elements", 0);
        ignoredElementsOption.setGroup(ignoreGroup);
        this.addAdvancedOption(KEY_OPTION_COMPARE_IGNORED_ELEMENTS, ignoredElementsOption);
        StringListOption ignoredAttributesOption = new StringListOption("Ignored Attributes", 1);
        ignoredAttributesOption.setGroup(ignoreGroup);
        this.addAdvancedOption(KEY_OPTION_COMPARE_IGNORED_ATTRIBUTES, ignoredAttributesOption);
        PreprocessorOption preprocessorOption = new PreprocessorOption("XSLT Preprocessor", 2);
        preprocessorOption.setGroup(new OptionGroup("Preprocessor", 1));
        this.addAdvancedOption(KEY_OPTION_COMPARE_PREPROCESSOR, preprocessorOption);
    }

    protected int getOptionIndex(String key) {
        Option option = this.getOptions().get(key);
        if (option == null) {
            option = this.getAdvancedOption(key);
        }
        return option == null ? -1 : option.getIndex();
    }

    protected void advancedOptionsToXml(Element parent) {
        Element ignore;
        if (this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ELEMENTS) != null) {
            Collection ignoredElements = ((StringListOption)this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ELEMENTS)).getValue() == null ? (Collection)((StringListOption)this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ELEMENTS)).getDefaultValue() : (Collection)((StringListOption)this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ELEMENTS)).getValue();
            for (StringOption option : ignoredElements) {
                if (option.isInherited()) continue;
                ignore = parent.getOwnerDocument().createElement("ignore");
                ignore.setAttribute("element", (String)option.getValue());
                parent.appendChild(ignore);
            }
        }
        if (this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ATTRIBUTES) != null) {
            Collection ignoredAttributes = ((StringListOption)this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ATTRIBUTES)).getValue() == null ? (Collection)((StringListOption)this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ATTRIBUTES)).getDefaultValue() : (Collection)((StringListOption)this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ATTRIBUTES)).getValue();
            for (StringOption option : ignoredAttributes) {
                if (option.isInherited()) continue;
                ignore = parent.getOwnerDocument().createElement("ignore");
                ignore.setAttribute("attribute", (String)option.getValue());
                parent.appendChild(ignore);
            }
        }
        if (this.getAdvancedOptions().get(KEY_OPTION_COMPARE_PREPROCESSOR) != null) {
            this.getAdvancedOptions().get(KEY_OPTION_COMPARE_PREPROCESSOR).toXml(parent);
        }
    }

    private boolean getType(String attribute) {
        return !attribute.equalsIgnoreCase("notequal");
    }

    private void addIgnore(Node ignore, boolean inherited) {
        NamedNodeMap attributes = ignore.getAttributes();
        int attrLength = attributes.getLength();
        for (int j = 0; j < attrLength; ++j) {
            StringListOption ignoredElements;
            Attr attribute = (Attr)attributes.item(j);
            String value = attribute.getValue();
            if (attribute.getName().equalsIgnoreCase("attribute")) {
                StringListOption ignoredAttributes = (StringListOption)this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ATTRIBUTES);
                if (ignoredAttributes.contains(value)) continue;
                ignoredAttributes.add(value, inherited);
                continue;
            }
            if (!attribute.getName().equalsIgnoreCase("element") || (ignoredElements = (StringListOption)this.getAdvancedOptions().get(KEY_OPTION_COMPARE_IGNORED_ELEMENTS)).contains(value)) continue;
            ignoredElements.add(value, inherited);
        }
    }

    private Element optionsToXml(Document ownerDocument, String elementName) {
        Element result = ownerDocument.createElement(elementName);
        result.setAttribute("name", this.getName());
        BooleanOption equal = (BooleanOption)this.getOptions().get(KEY_OPTION_COMPARE_EQUAL);
        if (equal.getValue() != null && ((Boolean)equal.getValue()).booleanValue()) {
            result.setAttribute("compareType", "equal");
        } else {
            result.setAttribute("compareType", "notequal");
        }
        this.getOption(KEY_OPTION_REFERENCE_FILE).toXml("reference", result);
        this.getOption(KEY_OPTION_TEST_FILE).toXml("test", result);
        this.advancedOptionsToXml(result);
        return result;
    }

    private void checkOptions(Element options, Map<String, String> properties, boolean inherited) {
        Object testFile;
        if (this.getOption(KEY_OPTION_REFERENCE_FILE).getValue() == null) {
            NodeList referenceFiles = options.getElementsByTagName("control");
            Object referenceFile = null;
            if (referenceFiles != null && referenceFiles.getLength() == 1) {
                referenceFile = this.createFileValue((Element)referenceFiles.item(0));
            } else {
                referenceFiles = options.getElementsByTagName("reference");
                if (referenceFiles != null && referenceFiles.getLength() == 1) {
                    referenceFile = this.createFileValue((Element)referenceFiles.item(0));
                }
            }
            Option referenceFileOption = this.getOption(KEY_OPTION_REFERENCE_FILE);
            referenceFileOption.setValue(referenceFile);
        }
        if ((testFile = this.getOption(KEY_OPTION_TEST_FILE).getValue()) == null) {
            NodeList testFiles = options.getElementsByTagName("test");
            if (testFiles != null && testFiles.getLength() == 1) {
                testFile = this.createFileValue((Element)testFiles.item(0));
            }
            Option testFileOption = this.getOption(KEY_OPTION_TEST_FILE);
            testFileOption.setValue(testFile);
        }
        String typeString = PropertiesHelper.getAttribute(options, "compareType", "equal", properties);
        this.getOption(KEY_OPTION_COMPARE_EQUAL).setValue(this.getType(typeString));
        NodeList children = options.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equalsIgnoreCase("preprocessor")) {
                TestDocumentPreprocessor preprocessor = new TestDocumentPreprocessor((Element)child, this.getName(), this.getOwner() == null ? "" : this.getOwner().getName());
                this.getAdvancedOption(KEY_OPTION_COMPARE_PREPROCESSOR).setValue(preprocessor);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("namespaceAware")) {
                this.namespaceAware = DomUtilities.getBooleanFromElement((Element)((Element)child), (boolean)false);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("validate")) {
                this.validate = DomUtilities.getBooleanFromElement((Element)((Element)child), (boolean)false);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("schemaValidation")) {
                this.schemaValidation = DomUtilities.getBooleanFromElement((Element)((Element)child), (boolean)false);
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("ignore")) continue;
            this.addIgnore(child, inherited);
        }
    }

    public static void removeHiddenData(Document referenceDocument, Document testDocument, Collection<String> ignoredElements, Collection<String> ignoredAttributes) {
        if (referenceDocument != null) {
            XMLCompare.removeElements(referenceDocument, ignoredElements);
            XMLCompare.removeAttributes(referenceDocument, ignoredAttributes);
        }
        if (testDocument != null) {
            XMLCompare.removeElements(testDocument, ignoredElements);
            XMLCompare.removeAttributes(testDocument, ignoredAttributes);
        }
    }

    private static void removeElements(Document document, Collection<String> ignoredElements) {
        if (ignoredElements != null) {
            for (String element : ignoredElements) {
                try {
                    List nodes = DomUtilities.selectNodes((Node)document.getDocumentElement(), (String)("//*[name()='" + element + "']"));
                    for (Node node : nodes) {
                        node.getParentNode().removeChild(node);
                    }
                }
                catch (XPathExpressionException xPathExpressionException) {
                }
            }
        }
    }

    private static void removeAttributes(Document document, Collection<String> ignoredAttributes) {
        if (ignoredAttributes != null) {
            for (String attribute : ignoredAttributes) {
                try {
                    List nodes = DomUtilities.selectNodes((Node)document.getDocumentElement(), (String)("//@*[name()='" + attribute + "']"));
                    for (Node node : nodes) {
                        ((Attr)node).getOwnerElement().removeAttribute(attribute);
                    }
                }
                catch (XPathExpressionException xPathExpressionException) {
                }
            }
        }
    }
}

