/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.dom.DomUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.test.PropertiesHelper;
import ch.e2e.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LogfileHeader {
    private ArrayList<Line> lines = new ArrayList();

    public LogfileHeader() {
    }

    public LogfileHeader(Element headerElement, HashMap<String, String> properties) {
        StringBuffer header = new StringBuffer();
        NodeList lines = headerElement.getElementsByTagName("Line");
        int length = lines.getLength();
        for (int i = 0; i < length; ++i) {
            Element line = (Element)lines.item(i);
            this.lines.add(new Line(PropertiesHelper.replaceProperties(DomUtilities.getTextValue((Element)line, (String)""), properties)));
        }
    }

    public Object createLine() {
        Line line = new Line();
        this.lines.add(line);
        return line;
    }

    public String toString() {
        StringBuffer header = new StringBuffer();
        for (Line line : this.lines) {
            header.append(PropertiesHelper.replaceProperties(line.toString())).append('\n');
        }
        return header.toString();
    }

    public LogfileHeader clone(Properties properties) {
        LogfileHeader result = new LogfileHeader();
        ArrayList<Line> clonedLines = new ArrayList<Line>();
        for (Line line : this.lines) {
            clonedLines.add(new Line(StringTools.replaceProperties((String)line.text, (Map)properties)));
        }
        result.lines = clonedLines;
        return result;
    }

    public Element toXML(Document ownerDocument) {
        Element result = ownerDocument.createElement("Header");
        for (Line line : this.lines) {
            Element lineElement = ownerDocument.createElement("Line");
            lineElement.appendChild(ownerDocument.createTextNode(line.text));
            result.appendChild(lineElement);
        }
        return result;
    }

    public class Line {
        protected String text;

        public Line() {
        }

        public Line(String text) {
            this.text = text;
        }

        public void addText(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text == null ? "" : this.text;
        }
    }
}

