/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.test.ErrorDetail;
import ch.e2e.test.TestFailedError;
import java.util.List;

public class E2EAssert {
    public static void assertTrue(String message, List<ErrorDetail> errorDetails, boolean condition) {
        if (!condition) {
            E2EAssert.fail(message, errorDetails);
        }
    }

    public static void assertFalse(String message, List<ErrorDetail> errorDetails, boolean condition) {
        E2EAssert.assertTrue(message, errorDetails, !condition);
    }

    public static void fail(String message, List<ErrorDetail> errorDetails) {
        throw new TestFailedError(message, errorDetails);
    }

    public static void assertEquals(String message, List<ErrorDetail> errorDetails, Object expected, Object actual) {
        if (!(expected == null && actual == null || expected != null && expected.equals(actual))) {
            E2EAssert.failNotEquals(message, errorDetails, expected, actual);
        }
    }

    public static void assertEquals(String message, List<ErrorDetail> errorDetails, double expected, double actual, double delta) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                E2EAssert.failNotEquals(message, errorDetails, expected, actual);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            E2EAssert.failNotEquals(message, errorDetails, expected, actual);
        }
    }

    public static void assertEquals(String message, List<ErrorDetail> errorDetails, float expected, float actual, float delta) {
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                E2EAssert.failNotEquals(message, errorDetails, Float.valueOf(expected), Float.valueOf(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            E2EAssert.failNotEquals(message, errorDetails, Float.valueOf(expected), Float.valueOf(actual));
        }
    }

    public static void assertEquals(String message, List<ErrorDetail> errorDetails, long expected, long actual) {
        E2EAssert.assertEquals(message, errorDetails, (Object)expected, (Object)actual);
    }

    public static void assertEquals(String message, List<ErrorDetail> errorDetails, boolean expected, boolean actual) {
        E2EAssert.assertEquals(message, errorDetails, (Object)expected, (Object)actual);
    }

    public static void assertEquals(String message, List<ErrorDetail> errorDetails, byte expected, byte actual) {
        E2EAssert.assertEquals(message, errorDetails, (Object)expected, (Object)actual);
    }

    public static void assertEquals(String message, List<ErrorDetail> errorDetails, char expected, char actual) {
        E2EAssert.assertEquals(message, errorDetails, Character.valueOf(expected), Character.valueOf(actual));
    }

    public static void assertEquals(String message, List<ErrorDetail> errorDetails, short expected, short actual) {
        E2EAssert.assertEquals(message, errorDetails, (Object)expected, (Object)actual);
    }

    public static void assertEquals(String message, List<ErrorDetail> errorDetails, int expected, int actual) {
        E2EAssert.assertEquals(message, errorDetails, (Object)expected, (Object)actual);
    }

    public static void assertNotNull(String message, List<ErrorDetail> errorDetails, Object object) {
        E2EAssert.assertTrue(message, errorDetails, object != null);
    }

    public static void assertNull(String message, List<ErrorDetail> errorDetails, Object object) {
        E2EAssert.assertTrue(message, errorDetails, object == null);
    }

    private static void failNotEquals(String message, List<ErrorDetail> errorDetails, Object expected, Object actual) {
        message = E2EAssert.format(message, expected, actual);
        E2EAssert.fail(message, errorDetails);
    }

    static String format(String message, Object expected, Object actual) {
        String formatted = message == null ? "" : message + " ";
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

