/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.dev.module.tasks;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import ch.e2e.builder.compiler.serviceRepository.ServiceRepositoryService;
import ch.e2e.builder.compiler.serviceRepository.stack.DevContainerResponse;
import ch.e2e.builder.compiler.serviceRepository.stack.DevStackResponse;
import ch.e2e.builder.compiler.utils.EnvUtils;
import com.scheer.pas.compiler.dev.api.DevStartEnvironment;
import com.scheer.pas.compiler.dev.module.tasks.DevEnvironmentTask;
import com.scheer.pas.compiler.dev.module.tasks.DevStartEnvironmentTask;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public class DevEnsureEnvironmentTask
extends DevEnvironmentTask {
    private static final int STARTUP_TIMEOUT = EnvUtils.get("xuml_development_service_startup_timeout", 20);

    public static Boolean select(String id) {
        return id.equals("dev.ensure.environment");
    }

    public DevEnsureEnvironmentTask(SourceManager sourceManager, String id, ServiceRepositoryService repositoryService, Client client) {
        super(sourceManager, id, repositoryService, client);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> sourceSet = super.getSourceSet();
        sourceSet.add("dev.start.environment");
        return sourceSet;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        DevStartEnvironmentTask task = (DevStartEnvironmentTask)this.sourceManager.getSource("dev.start.environment");
        DevStartEnvironment.Result result = task.getJsonDocument(DevStartEnvironment.Result.class);
        if (result == null) {
            result = new DevStartEnvironment.Result();
            result.setError(new BuildException("No result from dev.start.environment"));
            this.getErrorHandler().error((AbstractBuilderError)result.getError());
        } else if (result.getError() != null) {
            this.getErrorHandler().error((AbstractBuilderError)result.getError());
        } else {
            try {
                this.checkHealth(dependencyLevel, result);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.jsonDocument = result;
        JaxbUtils.marshalXml((Object)result, this.getDestinationFile());
    }

    @Override
    public boolean isUpToDate() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHealth(int dependencyLevel, DevStartEnvironment.Result result) throws InterruptedException {
        Object lock = new Object();
        DevEnvironmentTask.HealthCheckResult healthCheckResult = null;
        String devStackId = result.getDevStackResponse().getId();
        Object object = lock;
        synchronized (object) {
            for (int i = 0; i < STARTUP_TIMEOUT && !this.compileControl.shouldAbortTask(this.getTaskInfo(), dependencyLevel); ++i) {
                Logging.logger.info(String.format("try access development stack '%s' ...", devStackId));
                healthCheckResult = this.checkHealth(devStackId);
                if (healthCheckResult.healthy) {
                    result.setHealthCheck(new Date());
                    return;
                }
                lock.wait(1000L);
            }
        }
        Logging.logger.warning(String.format("development stack '%s' could not be reached (%s)", devStackId, healthCheckResult));
        this.getErrorHandler().error((Throwable)new BuildException(String.format("Development stack '%s' could not be reached (%s)", devStackId, healthCheckResult)));
    }

    private DevEnvironmentTask.HealthCheckResult checkHealth(String devStackId) {
        try {
            return this.checkContainersHealth(this.repositoryService.getDevStack(devStackId));
        }
        catch (Exception e) {
            return new DevEnvironmentTask.HealthCheckResult(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DevEnvironmentTask.HealthCheckResult checkContainersHealth(DevStackResponse devStack) {
        List healthCheckers = devStack.getContainers().stream().map(devContainerResponse -> new DevEnvironmentTask.HealthChecker((DevContainerResponse)devContainerResponse, this.client)).collect(Collectors.toList());
        Iterator iterator = healthCheckers.iterator();
        while (iterator.hasNext()) {
            DevEnvironmentTask.HealthChecker healthChecker = (DevEnvironmentTask.HealthChecker)iterator.next();
            try {
                Response response = healthChecker.getResponse();
                Throwable throwable = null;
                try {
                    if (response.getStatus() == 200) continue;
                    Response.StatusType status = response.getStatusInfo();
                    DevEnvironmentTask.HealthCheckResult healthCheckResult = healthChecker.newHealthCheckResult(String.format("%d - %s", status.getStatusCode(), status.getReasonPhrase()));
                    return healthCheckResult;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (Exception e) {
                return healthChecker.newHealthCheckResult(e);
            }
        }
        return new DevEnvironmentTask.HealthCheckResult();
    }
}

