/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.base.tasks.dev;

import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import com.scheer.pas.compiler.angular.core.constants.Files;
import com.scheer.pas.compiler.dev.api.artifacts.TestArtifactType;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class AngularTestArtifactType
extends TestArtifactType {
    @Override
    public Set<String> getRefreshTestArtifactsTaskBeforeSourceSet(SourceManager sourceManager) {
        return new HashSet<String>(Arrays.asList(Files.project_xml, Files.app_xml));
    }

    @Override
    public Set<String> getRefreshTestArtifactsTaskSourceSet(SourceManager sourceManager) {
        Set<String> result = super.getRefreshTestArtifactsTaskSourceSet(sourceManager);
        if (this.isExplicitAngularApp(sourceManager)) {
            result.add("dev.angular.sources");
        }
        return result;
    }

    private boolean isExplicitAngularApp(SourceManager sourceManager) {
        Path projectPath = sourceManager.getProjectFolder().toPath();
        XumlProject projectDocument = ((JsonDocumentSource)sourceManager.getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
        try {
            if (projectDocument.getApplication().getGenerateApplication().equalsIgnoreCase("always") || projectDocument.getApplication().getGenerateApplication().equalsIgnoreCase("ifforms") && AngularTestArtifactType.containsForms(projectPath)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static boolean containsForms(Path projectPath) throws IOException {
        try (Stream<Path> paths = java.nio.file.Files.walk(projectPath, new FileVisitOption[0]);){
            boolean bl = paths.anyMatch(path -> path.toString().endsWith(Extensions._form_json));
            return bl;
        }
    }
}

