/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.utils;

import java.util.Map;
import java.util.stream.Collectors;

public class EnvUtils {
    public static long get(String key, long defaultValue) {
        try {
            return Long.parseLong(System.getenv(key));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int get(String key, int defaultValue) {
        try {
            return Integer.parseInt(System.getenv(key));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String get(String key, String defaultValue) {
        String value = System.getenv(key);
        return value == null ? defaultValue : value;
    }

    public static boolean get(String key, boolean defaultValue) {
        String value = System.getenv(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public static Map<String, String> selectEnv(String keyPrefix, Map<String, String> env) {
        int prefixLength = keyPrefix.length();
        return env.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(keyPrefix)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(prefixLength), Map.Entry::getValue));
    }
}

