/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.dom.DomUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Value
implements Cloneable {
    public static final int UNDEFINED_VALUE = Integer.MIN_VALUE;
    private static final Value emptyValue = new EmptyValue();
    private static Document valueDocument = DomUtilities.newDocument();
    private String xmiID;
    private String value;
    private String name;
    private Element valueElement;

    public Value(String name, String type) {
        this.name = name;
        this.valueElement = valueDocument.createElement(name);
        this.valueElement.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", type);
        this.valueElement.setAttribute("visibility", "public");
    }

    private Value() {
    }

    public static Value getEmptyValue() {
        return emptyValue;
    }

    public void setValue(Object value) {
        this.value = value.toString();
        if (!value.equals(Integer.MIN_VALUE)) {
            this.valueElement.setAttribute("value", this.value);
        }
    }

    public String getXmiID(String parentXmiId, XmiIDFactory xmiIDFactory) {
        if (this.xmiID == null || this.xmiID.length() == 0) {
            this.xmiID = xmiIDFactory.getXmiID(this.name, "Value_" + parentXmiId);
        }
        return this.xmiID;
    }

    public void setXmiID(String xmiID) {
        this.xmiID = xmiID;
    }

    public String toString() {
        return this.value;
    }

    public Element toXMI(Document ownerDocument, String parentXmiId, XmiIDFactory xmiIDFactory) {
        this.valueElement.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getXmiID(parentXmiId, xmiIDFactory));
        return (Element)ownerDocument.adoptNode(this.valueElement);
    }

    public void appendToXMI(Element parent, XmiIDFactory xmiIDFactory) {
        String parentXmiId = parent.getAttributeNS("http://schema.omg.org/spec/XMI/2.1", "id");
        this.valueElement.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getXmiID(parentXmiId, xmiIDFactory));
        parent.appendChild(parent.getOwnerDocument().adoptNode(this.valueElement));
    }

    protected Object clone() throws CloneNotSupportedException {
        Value clone = (Value)super.clone();
        clone.setXmiID(null);
        clone.valueElement = (Element)this.valueElement.cloneNode(true);
        return clone;
    }

    private static class EmptyValue
    extends Value {
        private EmptyValue() {
        }

        @Override
        public void appendToXMI(Element parent, XmiIDFactory xmiIDFactory) {
        }
    }
}

