/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderErrorHandler;
import ch.e2e.builder.compiler.uml.ArtifactContainer;
import ch.e2e.builder.compiler.uml.ArtifactList;
import ch.e2e.builder.compiler.uml.BridgeRealization;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ChildAddedEvent;
import ch.e2e.builder.compiler.uml.ChildListener;
import ch.e2e.builder.compiler.uml.ChildRemovedEvent;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.ComponentContainer;
import ch.e2e.builder.compiler.uml.DependencyClient;
import ch.e2e.builder.compiler.uml.DependencyClientList;
import ch.e2e.builder.compiler.uml.DependencySupplierDefinition;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.event.EventController;
import ch.e2e.resource.ImageLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class ComponentDiagram
extends ClassifierElement
implements ChildListener {
    public static final String COMPONENT_DIAGRAM = "Component Diagram";
    public static final String COMPONENT_DIAGRAM_V2 = "Component Diagram Version 2";
    public static final String LIBRARY_DIAGRAM = "Library Diagram";
    public static final String LIBRARY_DIAGRAM_V2 = "Library Diagram Version 2";
    private String diagramType;
    private BuilderErrorHandler errorHandler;
    private ComponentContainer components;
    private ArtifactContainer customizedArtifacts;
    private ArrayList<UmlElement> deploymentElements;
    private DependencyClientList dependencyClients;
    private boolean aNew;

    public ComponentDiagram(BridgeStereotype stereotype, BridgeStereotype deployableStereotype, String componentsName, String[] componentsListNames, String artifactsName, String[] artifactsListNames, Helpers helpers) {
        super(stereotype, helpers);
        this.components = new ComponentContainer(this, deployableStereotype, componentsName, componentsListNames, helpers);
        if (artifactsName != null) {
            this.customizedArtifacts = new ArtifactContainer(this.components, this, artifactsName, artifactsListNames, helpers);
            this.customizedArtifacts.setChildListener(this);
            this.deploymentElements = new ArrayList();
        }
        this.dependencyClients = new DependencyClientList(helpers);
        this.setOwningPackage(this.getHelpers().getPackagesFactory().getInternalComponentDiagramPackage());
        this.errorHandler = new AbstractErrorHandler(){};
        this.aNew = false;
    }

    public ComponentDiagram(BridgeStereotype stereotype, BridgeStereotype deployableStereotype, String componentsName, String[] componentsListNames, Helpers helpers) {
        super(stereotype, helpers);
        this.components = new ComponentContainer(this, deployableStereotype, componentsName, componentsListNames, helpers);
        this.components.setChildListener(this);
        this.dependencyClients = new DependencyClientList(helpers);
        this.setOwningPackage(this.getHelpers().getPackagesFactory().getInternalComponentDiagramPackage());
        this.errorHandler = new AbstractErrorHandler(){};
        this.aNew = false;
    }

    @Override
    public boolean isNew() {
        return this.aNew;
    }

    public void setNew(boolean aNew) {
        this.aNew = aNew;
    }

    public String getDiagramType() {
        return this.diagramType;
    }

    public void setDiagramType(String diagramType) {
        this.diagramType = diagramType;
    }

    public BuilderErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public UmlElement getDeployables() {
        return this.components.getDeployables();
    }

    public ArtifactList getCustomizedDeployables() {
        return this.customizedArtifacts == null ? new ArtifactList.EmptyArtifactList(this.getHelpers()) : this.customizedArtifacts.getDeployables();
    }

    public boolean containsBackendType(BridgeStereotype stereotype) {
        return this.customizedArtifacts == null ? this.components.getBackendServices().getStereotype().getCustomization().getChildren().contains(stereotype) : this.customizedArtifacts.getBackendServices().getStereotype().getCustomization().getChildren().contains(stereotype);
    }

    public boolean containsProxyType(BridgeStereotype stereotype) {
        return this.customizedArtifacts != null && this.customizedArtifacts.getProxyServices().getStereotype().getCustomization().getChildren().contains(stereotype);
    }

    public UmlElement getBackendServices() {
        return this.components.getBackendServices();
    }

    public ArtifactList getCustomizedBackendServices() {
        return this.customizedArtifacts == null ? new ArtifactList.EmptyArtifactList(this.getHelpers()) : this.customizedArtifacts.getBackendServices();
    }

    public UmlElement getProxyServices() {
        return this.components.getProxyServices();
    }

    public ArtifactList getCustomizedProxyServices() {
        return this.customizedArtifacts == null ? new ArtifactList.EmptyArtifactList(this.getHelpers()) : this.customizedArtifacts.getProxyServices();
    }

    public boolean hasConfiguration() {
        BridgeStereotype configurationType = this.getHelpers().getStereotypeFactory().getStereotype("E2ECompositeDeployment");
        boolean result = false;
        int length = this.deploymentElements.size();
        for (int i = 0; i < length && !result; ++i) {
            DeploymentElement child = (DeploymentElement)this.deploymentElements.get(i);
            result = child.getStereotype().equals(configurationType);
        }
        return result;
    }

    public ArrayList<UmlElement> getDeploymentElements() {
        return this.deploymentElements;
    }

    @Override
    public void addChild(UmlElement child) {
    }

    @Override
    public String getBaseclass() {
        return "ComponentDiagram";
    }

    @Override
    public void childAdded(ChildAddedEvent event) {
        if (event.getChild() instanceof DeploymentElement) {
            this.addDependencyChild((DeploymentElement)event.getChild());
        }
        EventController.fire((EventObject)event);
        this.components.checkSelectable();
        if (this.customizedArtifacts != null) {
            this.customizedArtifacts.checkSelectable();
        }
    }

    private void addDependencyChild(DeploymentElement child) {
        if (child.getStereotype().getCustomization().hasBridgeDependencies()) {
            this.dependencyClients.addDependencyClient(child);
        }
        this.dependencyClients.addDependencySupplier(child);
        for (UmlElement umlElement : child.getChildren()) {
            this.addDependencyChild((DeploymentElement)umlElement);
        }
    }

    @Override
    public void childRemoved(ChildRemovedEvent event) {
        UmlElement child = event.getChild();
        if (child instanceof DeploymentElement) {
            if (child.getStereotype().getCustomization().hasBridgeDependencies()) {
                this.dependencyClients.removeDependencyClient((DeploymentElement)child);
            }
            this.dependencyClients.removeDependencySupplier((DeploymentElement)child);
        }
        this.components.checkSelectable();
        this.customizedArtifacts.checkSelectable();
        EventController.fire((EventObject)event);
    }

    public DependencyClientList getDependencyClients() {
        return this.dependencyClients;
    }

    public ArrayList<DependencySupplierDefinition> findRequiredSupplierTypes() {
        ArrayList<DependencySupplierDefinition> result = new ArrayList<DependencySupplierDefinition>();
        Iterator<UmlElement> children = this.deploymentElements.iterator();
        while (children.hasNext() && result.size() == 0) {
            result.addAll(((DeploymentElement)children.next()).findRequiredSupplierTypes());
        }
        return result;
    }

    @Override
    public int getChildCount() {
        return this.customizedArtifacts == null ? 1 : 2;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public UmlElement getChild(int index) {
        return index == 0 ? this.components : this.customizedArtifacts;
    }

    @Override
    public Icon getIcon() {
        return ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/component.diagram.small.icon.gif", (boolean)true);
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    public boolean canSkip(UmlElement currentElement) {
        boolean skip = currentElement instanceof DependencyClient ? this.dependencyClients.areAllSuppliersConnected() : (this.customizedArtifacts == null ? this.components.canSkip(currentElement) : this.customizedArtifacts.canSkip(currentElement));
        return skip;
    }

    public BridgeStereotype findRequiredNodeType(UmlElement currentElement) {
        return this.customizedArtifacts == null ? this.components.findRequiredNodeType(currentElement) : this.customizedArtifacts.findRequiredNodeType(currentElement);
    }

    public boolean isNextNodeType(DeploymentElement currentElement, BridgeStereotype nodeType) {
        return this.customizedArtifacts.isNextNodeType(currentElement, nodeType);
    }

    public ArrayList<BridgeStereotype> getRemainingNodeTypes(DeploymentElement currentElement) {
        return this.customizedArtifacts.getRemainingNodeTypes(currentElement);
    }

    public ArrayList<BridgeStereotype> findRequiredNodeChildren(BridgeStereotype nodeType) {
        return this.customizedArtifacts.findRequiredNodeChildren(nodeType);
    }

    @Override
    public ArrayList<ClassifierElement> findChildrenOfTypes(ArrayList<BridgeStereotype> childTypes) {
        return this.components.findChildrenOfTypes(childTypes);
    }

    public DeploymentElement findArtifact(UmlElement classifier) {
        return this.customizedArtifacts.findArtifact(classifier);
    }

    public void prepareForImport() {
        UmlElement reference;
        HashMap<String, UmlElement> allReferences = new HashMap<String, UmlElement>();
        ArrayList<UmlElement> children = new ArrayList<UmlElement>();
        for (UmlElement child : this.components.getDeployables().getAllChildren()) {
            reference = child.createReference(allReferences, this);
            reference.setParent(this);
            children.add(reference);
            allReferences.put(child.getXmiID(), reference);
        }
        this.components.getDeployables().setAllChildren(children);
        children = new ArrayList();
        for (UmlElement child : this.components.getBackendServices().getAllChildren()) {
            reference = child.createReference(allReferences, this);
            reference.setParent(this);
            children.add(reference);
        }
        this.components.getBackendServices().setAllChildren(children);
        children = new ArrayList();
        if (this.customizedArtifacts != null) {
            for (UmlElement child : this.customizedArtifacts.getDeployables().getAllChildren()) {
                reference = child.createReference(allReferences, this);
                reference.setParent(this);
                children.add(reference);
            }
            this.customizedArtifacts.getDeployables().setAllChildren(children);
            children = new ArrayList();
            for (UmlElement child : this.customizedArtifacts.getBackendServices().getAllChildren()) {
                reference = child.createReference(allReferences, this);
                reference.setParent(this);
                children.add(reference);
            }
            this.customizedArtifacts.getBackendServices().setAllChildren(children);
        }
    }

    public List<UmlElement> findDependencyClients(BridgeStereotype stereotype) {
        ArrayList<UmlElement> dependencyClients = new ArrayList<UmlElement>();
        for (UmlElement child : this.components.getDeployables().getAllChildren()) {
            dependencyClients.addAll(this.findDependencyClients(child, stereotype));
        }
        return dependencyClients;
    }

    private Collection<? extends UmlElement> findDependencyClients(UmlElement child, BridgeStereotype stereotype) {
        BridgeStereotype childStereotype;
        ArrayList<? extends UmlElement> dependencyClients = new ArrayList<UmlElement>();
        BridgeStereotype bridgeStereotype = childStereotype = child instanceof BridgeRealization ? ((BridgeRealization)child).getClassifier().getStereotype() : child.getStereotype();
        if (childStereotype.getCustomization().getBridgeDependencies().contains(stereotype)) {
            dependencyClients.add(child);
        }
        for (UmlElement umlElement : child.getAllChildren()) {
            dependencyClients.addAll(this.findDependencyClients(umlElement, stereotype));
        }
        return dependencyClients;
    }
}

