/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.serviceRepository;

import ch.e2e.builder.compiler.serviceRepository.stack.DevContainerRequest;
import ch.e2e.builder.compiler.serviceRepository.stack.DevContainerType;
import ch.e2e.builder.compiler.serviceRepository.stack.DevStackOptions;
import ch.e2e.builder.compiler.serviceRepository.stack.DevStackRequest;
import ch.e2e.builder.compiler.serviceRepository.stack.DevStackResponse;
import ch.e2e.builder.compiler.utils.EnvUtils;
import ch.e2e.builder.compiler.utils.TokenManager;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.concurrent.Future;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class ServiceRepositoryService {
    private static final String SERVICE_REPOSITORY_PROTOCOL = EnvUtils.get("SERVICE_REPOSITORY_PROTOCOL", "http");
    private static final String SERVICE_REPOSITORY_HOSTNAME = EnvUtils.get("SERVICE_REPOSITORY_HOSTNAME", "service-repository-nestjs");
    private static final int SERVICE_REPOSITORY_PORT = EnvUtils.get("SERVICE_REPOSITORY_PORT", 8080);
    private static final String SERVICE_REPOSITORY_DEV_STACK_PATH = EnvUtils.get("SERVICE_REPOSITORY_DEV_STACK_PATH", "dev-stack");
    private static final UriBuilder SERVICE_REPOSITORY_DEV_STACK_URI = UriBuilder.fromPath((String)SERVICE_REPOSITORY_DEV_STACK_PATH).scheme(SERVICE_REPOSITORY_PROTOCOL).host(SERVICE_REPOSITORY_HOSTNAME).port(SERVICE_REPOSITORY_PORT);
    private final WebTarget devStackTarget;
    private final TokenManager tokenManager;
    public static final String DEV_STACK_LABEL_PROJECT_ID = "project.id";
    public static final String XUML_DEV_CUSTOM_LABEL_PREFIX = EnvUtils.get("XUML_DEV_CUSTOM_LABEL_PREFIX", "com.scheer-pas.custom-label.xuml-dev.");
    public static final String ANGULAR_DEV_CUSTOM_LABEL_PREFIX = EnvUtils.get("ANGULAR_DEV_CUSTOM_LABEL_PREFIX", "com.scheer-pas.custom-label.ng-dev.");
    private static final MultivaluedHashMap<String, Object> NO_QUERY_PARAMS = new MultivaluedHashMap();

    public ServiceRepositoryService(Client client, TokenManager tokenManager) {
        this.devStackTarget = client.target(SERVICE_REPOSITORY_DEV_STACK_URI);
        this.tokenManager = tokenManager;
    }

    public DevStackResponse createDevStack(String projectId, DevStackOptions devStackOptions) {
        DevContainerRequest xumlContainer = new DevContainerRequest(DevContainerType.XUML).ports(devStackOptions.getXumlPorts()).label(DEV_STACK_LABEL_PROJECT_ID, projectId).env(devStackOptions.getEnv()).env(devStackOptions.getXumlEnv());
        DevContainerRequest angularContainer = new DevContainerRequest(DevContainerType.ANGULAR).label(DEV_STACK_LABEL_PROJECT_ID, projectId).env(devStackOptions.getEnv()).env(devStackOptions.getAngularEnv());
        DevStackRequest request = new DevStackRequest().container(xumlContainer).container(angularContainer);
        return (DevStackResponse)this.newInvocationBuilder().post(Entity.entity((Object)request, (MediaType)MediaType.APPLICATION_JSON_TYPE), DevStackResponse.class);
    }

    public DevStackResponse getDevStack(DevStackResponse devStack) {
        return this.getDevStack(devStack.getId());
    }

    public DevStackResponse getDevStack(DevStackResponse devStack, boolean fetchMeta) {
        return this.getDevStack(devStack.getId(), fetchMeta);
    }

    public DevStackResponse getDevStack(String id) {
        return this.getDevStack(id, false);
    }

    public DevStackResponse getDevStack(String id, boolean fetchMeta) {
        MultivaluedHashMap queryParams = new MultivaluedHashMap();
        queryParams.add((Object)"fetchMeta", (Object)fetchMeta);
        return (DevStackResponse)this.newInvocationBuilder(id, (MultivaluedMap<String, Object>)queryParams).get(DevStackResponse.class);
    }

    public void removeDevStack(DevStackResponse devStack) {
        this.removeDevStack(devStack.getId());
    }

    public void removeDevStack(String id) {
        this.newInvocationBuilder(id).delete(JsonNode.class);
    }

    public Future<Response> asyncRemoveDevStack(DevStackResponse devStack) {
        return this.asyncRemoveDevStack(devStack.getId());
    }

    public Future<Response> asyncRemoveDevStack(String devStackId) {
        return this.newAsyncInvocationBuilder(devStackId, (MultivaluedMap<String, Object>)NO_QUERY_PARAMS).delete();
    }

    public DevStackResponse[] getDevStacksForProject(String projectId) {
        return (DevStackResponse[])Arrays.stream(this.getDevStacks()).filter(stack -> stack.getContainers().stream().anyMatch(container -> projectId.equals(container.getProjectId()))).toArray(DevStackResponse[]::new);
    }

    public DevStackResponse[] getDevStacks() {
        return (DevStackResponse[])this.newInvocationBuilder().get(DevStackResponse[].class);
    }

    private Invocation.Builder newInvocationBuilder() {
        return this.newInvocationBuilder("");
    }

    private Invocation.Builder newInvocationBuilder(String path) {
        return this.newInvocationBuilder(path, (MultivaluedMap<String, Object>)NO_QUERY_PARAMS);
    }

    private Invocation.Builder newInvocationBuilder(String path, MultivaluedMap<String, Object> queryParams) {
        queryParams.forEach((name, values) -> values.forEach(value -> this.devStackTarget.queryParam(name, new Object[]{value})));
        return this.devStackTarget.path(path).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)this.tokenManager.getBearerTokenString());
    }

    private AsyncInvoker newAsyncInvocationBuilder(String path, MultivaluedMap<String, Object> queryParams) {
        return this.newInvocationBuilder(path, queryParams).async();
    }
}

