/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import ch.e2e.builder.compiler.net.BridgeResultError;
import ch.e2e.dom.DomUtilities;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BridgeResultParser {
    private ArrayList<BridgeResultError> warnings = new ArrayList();
    private ArrayList<BridgeResultError> errors = new ArrayList();
    private ArrayList<BridgeResultError> fatalErrors = new ArrayList();

    public BridgeResultParser(String result) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        Document answer = DomUtilities.parse((Reader)new StringReader(result), (boolean)false, (boolean)false);
        Element answerElement = answer.getDocumentElement();
        NodeList statusList = answerElement.getElementsByTagNameNS("http://e2e.ch/bridge", "Status");
        if (statusList != null && statusList.getLength() > 0) {
            Element statusElement = (Element)statusList.item(0);
            String status = statusElement.getFirstChild().getNodeValue();
            this.checkStatus(status, answerElement);
        }
    }

    public ArrayList<BridgeResultError> getErrors() {
        return this.errors;
    }

    public ArrayList<BridgeResultError> getFatalErrors() {
        return this.fatalErrors;
    }

    public ArrayList<BridgeResultError> getWarnings() {
        return this.warnings;
    }

    private void checkStatus(String status, Element answerElement) {
        if (!status.equals("OK")) {
            Element messageElement = (Element)answerElement.getElementsByTagNameNS("http://e2e.ch/bridge", "Message").item(0);
            String id = messageElement.getAttribute("id");
            if (id.length() == 0) {
                id = messageElement.getFirstChild().getNodeValue();
            }
            BridgeResultError error = new BridgeResultError(null, id);
            if (status.equalsIgnoreCase("ERROR")) {
                this.errors.add(error);
            } else if (status.equalsIgnoreCase("FATAL")) {
                this.fatalErrors.add(error);
            } else if (status.equalsIgnoreCase("WARN")) {
                this.warnings.add(error);
            }
        }
    }
}

