/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.resource;

import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImportSource;
import ch.e2e.builder.compiler.document.importer.resource.Resource;
import ch.e2e.builder.compiler.document.importer.resource.ResourceArchive;
import ch.e2e.builder.compiler.document.importer.resource.ResourceFile;
import ch.e2e.builder.compiler.document.importer.resource.ResourceImportDataModel;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.ModelPackage;
import ch.e2e.builder.compiler.uml.UserArtifactTemplate;
import ch.e2e.builder.compiler.uml.UserComponentTemplate;
import java.io.File;
import org.w3c.dom.Document;

public class ResourceImportSource
extends ImportSource {
    private static final String RESOURCES_PACKAGE = "Component View/Resources";
    private ResourceImportDataModel dataModel;
    private Resource[] resources;
    private Helpers helpers;

    public ResourceImportSource(Resource[] resources, String name, File importsFolder, Helpers helpers) {
        this.helpers = helpers;
        this.resources = resources;
        this.dataModel = new ResourceImportDataModel(name, importsFolder, helpers);
        this.addResources(resources);
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public Document getSourceDocument() {
        for (ModelPackage modelPackage : this.dataModel.getModel().getPackages()) {
            this.dataModel.addSharedPackage(modelPackage.getOrigin());
        }
        return this.dataModel.createDocument();
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public String getDevelopmentFilename() {
        return null;
    }

    @Override
    public ImportModel getImportModel() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    private void addResources(Resource[] resources) {
        BridgePackage templates = this.helpers.getPackagesFactory().createPackages("Component View/Templates", this.dataModel.getImportRoot(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
        BridgePackage componentView = this.helpers.getPackagesFactory().createPackages("Component View", this.dataModel.getImportRoot(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
        BridgePackage componentsPackage = this.helpers.getPackagesFactory().createPackages("Component View/Components", this.dataModel.getImportRoot(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
        for (Resource resource : resources) {
            if (resource instanceof ResourceArchive) {
                this.addResourceArchive((ResourceArchive)resource, templates, componentsPackage);
                continue;
            }
            ClassifierElement resourceClassifier = this.createResource(resource);
            UserArtifactTemplate resourceArtifact = new UserArtifactTemplate(resource.getName(), new Comment("", this.helpers), resource.getStereotype(), this.helpers);
            resourceArtifact.setClassifier(resourceClassifier);
            resourceArtifact.setOwningPackage(templates);
            resourceArtifact.setPropertyValueQuietly("deploy", resource.isDeploy());
            this.dataModel.addElement(resourceArtifact);
            DeploymentElement artifact = new DeploymentElement(resource.getName(), new Comment("", this.helpers), resource.getStereotype(), this.helpers);
            String targetFolder = (String)resource.getStereotype().getProperty("targetFolder").getValue();
            targetFolder = targetFolder.replaceFirst(String.valueOf(targetFolder.charAt(0)), String.valueOf(Character.toUpperCase(targetFolder.charAt(0))));
            BridgePackage targetPackage = this.helpers.getPackagesFactory().createPackages(targetFolder, componentView, this.helpers.getStereotypeFactory().getStereotype("Repository"));
            artifact.setOwningPackage(targetPackage);
            this.dataModel.addElement(artifact);
            if (!resource.hasProperty("charset")) continue;
            resourceArtifact.setPropertyValueQuietly("charset", resource.getCharset().toString());
            artifact.setPropertyValueQuietly("charset", resource.getCharset().toString());
        }
    }

    private void addResourceArchive(ResourceArchive resourceArchive, BridgePackage templates, BridgePackage componentsPackage) {
        UserComponentTemplate archive = new UserComponentTemplate(resourceArchive.getFileName(), new Comment("", this.helpers), resourceArchive.getStereotype().getClassifierType(), this.helpers);
        archive.setOwningPackage(templates);
        UserArtifactTemplate artifact = new UserArtifactTemplate(resourceArchive.getName(), new Comment("", this.helpers), resourceArchive.getStereotype(), this.helpers);
        artifact.setClassifier(archive);
        artifact.setOwningPackage(templates);
        artifact.setPropertyValueQuietly("deploy", resourceArchive.isDeploy());
        if (resourceArchive.canExtract()) {
            artifact.setPropertyValueQuietly("extractAll", resourceArchive.getPropertyValueQuietly("extractAll"));
        }
        DeploymentElement archiveComponent = new DeploymentElement(resourceArchive.getName(), new Comment("", this.helpers), resourceArchive.getStereotype(), this.helpers);
        archiveComponent.setOwningPackage(componentsPackage);
        for (ResourceFile resource : resourceArchive.getResources()) {
            ClassifierElement resourceClassifier = this.createResource(resource);
            archive.addChild(resourceClassifier);
            UserArtifactTemplate entryArtifact = new UserArtifactTemplate(resource.getName(), new Comment("", this.helpers), resource.getStereotype(), this.helpers);
            artifact.addChild(entryArtifact);
            entryArtifact.setClassifier(resourceClassifier);
            this.dataModel.addElement(entryArtifact);
            DeploymentElement entryComponent = new DeploymentElement(resource.getName(), new Comment("", this.helpers), resource.getStereotype(), this.helpers);
            archiveComponent.addChild(entryComponent);
            this.dataModel.addElement(entryComponent);
            if (!resource.hasProperty("charset")) continue;
            entryArtifact.setPropertyValueQuietly("charset", resource.getCharset().toString());
            entryComponent.setPropertyValueQuietly("charset", resource.getCharset().toString());
        }
        this.dataModel.addElement(archive);
        this.dataModel.addElement(artifact);
        this.dataModel.addElement(archiveComponent);
    }

    private ClassifierElement createResource(Resource resource) {
        BridgePackage interfacePackage = this.helpers.getPackagesFactory().createPackages(RESOURCES_PACKAGE, this.dataModel.getImportRoot(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
        ClassifierElement classifier = new ClassifierElement(resource.getName().replace('.', '_'), new Comment("", this.helpers), resource.getStereotype().getClassifierType(), this.helpers);
        classifier.setPropertyValueQuietly("defaultArtifactName", resource.getName());
        classifier.setOwningPackage(interfacePackage);
        this.dataModel.addElement(classifier);
        return classifier;
    }
}

