/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer;

public abstract class AliasQuestion {
    public static final String ALIAS_QUESTION_KEY = "ch.e2e.builder.compiler.document.importer";
    private static AliasQuestion aliasQuestion;

    protected AliasQuestion() {
    }

    public static AliasQuestion getInstance() {
        if (aliasQuestion == null) {
            aliasQuestion = AliasQuestion.createAliasQuestion();
        }
        return aliasQuestion;
    }

    public abstract boolean isAliasForSimplifiedComponentDiagram();

    private static AliasQuestion createAliasQuestion() {
        AliasQuestion question;
        try {
            String classname = System.getProperty(ALIAS_QUESTION_KEY);
            Class<?> myClass = Class.forName(classname, true, AliasQuestion.class.getClassLoader());
            question = (AliasQuestion)myClass.newInstance();
        }
        catch (Throwable e) {
            question = new DefaultAliasQuestion();
        }
        return question;
    }

    private static class DefaultAliasQuestion
    extends AliasQuestion {
        private DefaultAliasQuestion() {
        }

        @Override
        public boolean isAliasForSimplifiedComponentDiagram() {
            return true;
        }
    }
}

