/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.compiler.descriptor.ClasspathResource;
import ch.e2e.builder.compiler.descriptor.RepositoryArchiveResource;
import ch.e2e.builder.compiler.descriptor.RepositoryResource;
import ch.e2e.builder.compiler.descriptor.ResourceList;
import ch.e2e.builder.compiler.descriptor.UIResource;
import ch.e2e.builder.compiler.descriptor.XSLTRepositoryArchiveResource;
import ch.e2e.builder.compiler.descriptor.XSLTResource;
import ch.e2e.builder.compiler.tools.UmlLocationElement;
import ch.e2e.dom.DomUtilities;
import ch.e2e.util.StringTools;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class DescriptorElement
implements UmlLocationElement {
    private static HashMap<String, Class> resourceClasses = new HashMap();
    private String documentation;
    private ResourceList resources = new ResourceList();
    private String umlLocation;

    @Override
    public String getUmlLocation() {
        return this.umlLocation;
    }

    protected DescriptorElement(Element xmlElement) {
        this.umlLocation = xmlElement.getAttribute("id");
        this.initialize(xmlElement);
    }

    protected void initialize(Element xmlElement) {
        this.readDocumentation(xmlElement);
    }

    public void clear() {
        this.resources.clear();
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public ResourceList getResources() {
        return this.resources;
    }

    protected void readResources(Element xmlElement, String xPath) {
        this.readResources(xmlElement, xPath, this.resources);
    }

    protected void readResources(Element xmlElement, String xPath, ResourceList resources) {
        try {
            List resourceList = DomUtilities.selectNodes((Node)xmlElement, (String)xPath);
            if (resourceList != null) {
                for (Node node : resourceList) {
                    RepositoryResource resource = this.createResource((Element)node);
                    resources.addResource(resource);
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    protected RepositoryResource createResource(Element node) {
        RepositoryResource resource;
        ArrayList<String> stereotypes;
        try {
            stereotypes = new ArrayList<String>(Arrays.asList(StringTools.createStringArray((String)node.getAttribute("stereotypes"))));
        }
        catch (ParseException e) {
            stereotypes = new ArrayList<String>();
        }
        Class resourceClass = this.findResourceClass(stereotypes);
        try {
            Constructor constructor = resourceClass.getConstructor(Element.class, DescriptorElement.class);
            resource = (RepositoryResource)constructor.newInstance(node, this);
        }
        catch (Exception e) {
            resource = new RepositoryResource(node, this);
        }
        return resource;
    }

    private Class findResourceClass(ArrayList<String> stereotypes) {
        Class result = null;
        int length = stereotypes.size();
        for (int i = 0; i < length && result == null; ++i) {
            result = resourceClasses.get(stereotypes.get(i));
        }
        if (result == null) {
            result = RepositoryResource.class;
        }
        return result;
    }

    private void readDocumentation(Element xmlElement) {
        Element documentationElement = this.findDocumentationElement(xmlElement);
        this.documentation = documentationElement == null ? "" : this.readDocumentationText(documentationElement);
    }

    private Element findDocumentationElement(Element xmlElement) {
        Element documentationElement = null;
        if (xmlElement != null) {
            NodeList childs = xmlElement.getChildNodes();
            int length = childs.getLength();
            for (int i = 0; i < length && documentationElement == null; ++i) {
                if (!childs.item(i).getNodeName().equals("Documentation")) continue;
                documentationElement = (Element)childs.item(i);
            }
        }
        return documentationElement;
    }

    private String readDocumentationText(Element documentationElement) {
        String documentation = "";
        NodeList childs = documentationElement.getChildNodes();
        int length = childs.getLength();
        for (int i = 0; i < length; ++i) {
            if (!(childs.item(i) instanceof Text)) continue;
            documentation = childs.item(i).getNodeValue();
            break;
        }
        return documentation;
    }

    static {
        resourceClasses.put("ArchiveFile", RepositoryArchiveResource.class);
        resourceClasses.put("UIRepositoryArtifact", UIResource.class);
        resourceClasses.put("XSLTArchiveFile", XSLTRepositoryArchiveResource.class);
        resourceClasses.put("XSLTScriptFile", XSLTResource.class);
        resourceClasses.put("ClasspathResourceFile", ClasspathResource.class);
    }
}

