/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.tabfile;

import ch.e2e.builder.compiler.build.types.tabfile.SimpleElement;
import org.w3c.dom.Element;

public class TextElement
extends SimpleElement {
    private String elementName;
    private String text;

    public TextElement(String elementName) {
        this.elementName = elementName;
    }

    public TextElement(String elementName, String text) {
        this(elementName);
        this.text = text;
    }

    public TextElement(Element tabfileElement) {
        super(tabfileElement);
        this.elementName = tabfileElement.getTagName();
        this.text = tabfileElement.getTextContent();
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Element buildDom(Element parent, boolean library) {
        Element me = super.buildDom(parent, library);
        me.setTextContent(this.getText());
        return me;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextElement)) {
            return false;
        }
        TextElement that = (TextElement)o;
        if (!this.getElementName().equals(that.getElementName())) {
            return false;
        }
        return this.getText() != null ? this.getText().equals(that.getText()) : that.getText() == null;
    }

    @Override
    public int hashCode() {
        int result = this.getElementName().hashCode();
        result = 31 * result + (this.getText() != null ? this.getText().hashCode() : 0);
        return result;
    }
}

