/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.BridgeXmiFile;
import ch.e2e.builder.compiler.build.types.E2EBuilderDataType;
import ch.e2e.builder.compiler.build.types.Logging;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.dom.DomUtilities;
import ch.e2e.util.VersionChecker;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Xmi2Descriptor
implements E2EBuilderDataType,
Logging {
    private static String scriptVersion = "0";
    private UmlDocument umlDocument;
    private BridgeXmiFile srcfile;
    private File targetfile;

    public Xmi2Descriptor(UmlDocument umlDocument) {
        this.umlDocument = umlDocument;
    }

    public static String getScriptVersion() {
        return scriptVersion;
    }

    @Override
    public boolean isUpToDate(CompilableObject configuration) {
        boolean result = true;
        if (this.umlDocument.isDescriptorIncluded()) {
            this.srcfile = new BridgeXmiFile(this.umlDocument);
            this.targetfile = this.umlDocument.getDescriptorFile();
            if (this.srcfile.exists()) {
                result = this.srcfile.isUpToDate(configuration);
                result = result && this.targetfile.exists() ? this.checkTargetfile() : false;
            }
            if (!result) {
                this.targetfile.delete();
            }
        }
        return result;
    }

    public BridgeXmiFile getSrcfile() {
        return this.srcfile;
    }

    private boolean checkTargetfile() {
        boolean result = this.targetfile.lastModified() > this.srcfile.lastModified() ? this.checkScriptVersion() : false;
        return result;
    }

    private boolean checkScriptVersion() {
        boolean result = false;
        try {
            File xmlfile = this.targetfile;
            Document descriptorDocument = DomUtilities.parse((File)xmlfile, (boolean)false, (boolean)false);
            Element root = descriptorDocument.getDocumentElement();
            String lastVersion = root.getAttribute("scriptversion");
            if (VersionChecker.checkVersion((String)scriptVersion, (String)lastVersion)) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "checkScriptVersion", e);
        }
        return result;
    }
}

