/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.E2EBuilderDataType;
import ch.e2e.builder.compiler.build.types.TabfileMergeContainer;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.builder.compiler.document.DependsFile;
import ch.e2e.builder.compiler.document.IncludesFile;
import ch.e2e.builder.compiler.document.UmlDocument;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class TabfileMerge
implements E2EBuilderDataType {
    private UmlDocument umlDocument;
    private boolean library;
    private ArrayList<File> allSrcFiles;

    public TabfileMerge(UmlDocument umlDocument, boolean library) {
        this.umlDocument = umlDocument;
        this.library = library;
    }

    @Override
    public boolean isUpToDate(CompilableObject compilableObject) {
        boolean result = true;
        long lastModified = Long.MAX_VALUE;
        Iterator<Deployment> deployments = compilableObject.getDeployments().iterator();
        while (deployments.hasNext() && result) {
            Deployment deployment = deployments.next();
            TabfileMergeContainer targetFile = this.getTargetFile(deployment.getName());
            result = targetFile.exists();
            lastModified = Math.min(lastModified, targetFile.lastModified());
        }
        if (result) {
            result = this.checkSources(lastModified, compilableObject.getLibraries());
        }
        return result;
    }

    private boolean checkSources(long lastModified, ArrayList<LibraryService> modules) {
        int i;
        boolean result = true;
        ArrayList<File> sources = this.getAllSrcFiles();
        int length = sources.size();
        for (i = 0; i < length && result; ++i) {
            File file = sources.get(i);
            result = file.lastModified() < lastModified;
        }
        length = modules.size();
        for (i = 0; i < length && result; ++i) {
            result = modules.get(i).getRepository().lastModified() < lastModified;
        }
        return result;
    }

    public ArrayList<File> getAllSrcFiles() {
        if (this.allSrcFiles == null) {
            this.allSrcFiles = new ArrayList();
            this.addTabfilesFile(this.umlDocument);
            ArrayList<String> addedDependencies = new ArrayList<String>();
            this.readSources(this.umlDocument, addedDependencies);
        }
        return this.allSrcFiles;
    }

    private void readSources(UmlDocument umlDocument, ArrayList<String> addedDependencies) {
        if (!addedDependencies.contains(umlDocument.getUniqueId())) {
            addedDependencies.add(umlDocument.getUniqueId());
            DependsFile dependsFile = umlDocument.getDocumentInfo().getDependsFile();
            for (IncludesFile includesFile : dependsFile.getIncludesFiles().values()) {
                UmlDocument importedDocument = umlDocument.getUmlDocumentFactory().getUmlDocumentById(includesFile.getUmlFileID());
                if (importedDocument == null) continue;
                this.addTabfilesFile(importedDocument);
                this.readSources(importedDocument, addedDependencies);
            }
        }
    }

    private void addTabfilesFile(UmlDocument umlDocument) {
        File tabfilesFile = new File(umlDocument.getDocumentWorkingFolder(), umlDocument.getUniqueId() + ".tabfiles");
        if (!this.allSrcFiles.contains(tabfilesFile)) {
            this.allSrcFiles.add(tabfilesFile);
        }
    }

    public TabfileMergeContainer getTargetFile(String deployment) {
        return new TabfileMergeContainer(new File(this.umlDocument.getDocumentWorkingFolder(), deployment + (this.library ? ".library.tabfiles" : ".composite.tabfiles")), this.library);
    }
}

