/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.libraries;

import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.BuildLibraryTask;
import ch.e2e.builder.compiler.build.tasks.model.ZipTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.form.FormHelper;
import ch.e2e.builder.compiler.build.tasks.source.FileSource;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import com.scheer.pas.compiler.xuml.api.tasks.libraries.LibraryItemTypeService;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class XlibZipTask
extends ZipTask {
    public static String TASK_ID = "library.build.xlib";
    private final LibraryItemTypeService libraryItemTypeService;
    private static final String[] ALLOWED_EXTENSIONS = new String[]{Extensions._descriptor_json, Extensions._form_json, Extensions._lrep};

    public XlibZipTask(SourceManager sourceManager, String id, LibraryItemTypeService libraryItemTypeService) {
        super(sourceManager, id);
        this.libraryItemTypeService = libraryItemTypeService;
    }

    public XumlProject getProject() {
        return ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
    }

    @Override
    protected Path[] getInputFolderPaths() {
        return new Path[0];
    }

    @Override
    protected Map<String, File> getInputFiles() {
        HashMap<String, File> result = new HashMap<String, File>();
        result.put(this.getProject().getName() + Extensions._lrep, ((CacheAbleTask)this.getSourceManager().getSource(BuildLibraryTask.TASK_ID)).getDestinationFile());
        result.put(Files.library_descriptor_json, ((CacheAbleTask)this.getSourceManager().getSource(Folders.library_ + Files.library_descriptor_json)).getDestinationFile());
        Set<String> exposedForms = FormHelper.getLibraryForms(this.getSourceManager());
        if (!exposedForms.isEmpty()) {
            exposedForms.forEach(form -> result.put(Files.forms__FORM_library_form_json(form), ((FileSource)this.getSourceManager().getSource(Files.form__FORM_library_form_json(form))).getFile()));
        }
        this.libraryItemTypeService.getItemTypes().forEach(itemType -> result.putAll(itemType.getXlibZipInputFiles(this.getSourceManager())));
        return result;
    }

    @Override
    public File getDestinationFile() {
        return new File(this.sourceManager.getWorkFolder(), Files.library__PROJECTNAME_xlib(this.getProject().getName()));
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._xlib;
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(Files.project_xml);
        result.addAll(FormHelper.getFormJsonDocumentSourceSet(this.getSourceManager()));
        this.libraryItemTypeService.getItemTypes().forEach(itemType -> result.addAll(itemType.getXlibZipBeforeSourceSet(this.getSourceManager())));
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(Folders.library_ + Files.library_descriptor_json);
        result.add(BuildLibraryTask.TASK_ID);
        Set<String> exposedForms = FormHelper.getLibraryForms(this.getSourceManager());
        if (!exposedForms.isEmpty()) {
            exposedForms.forEach(form -> result.add(Files.form__FORM_library_form_json(form)));
        }
        this.libraryItemTypeService.getItemTypes().forEach(itemType -> result.addAll(itemType.getXlibZipSourceSet(this.getSourceManager())));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doFilter(Path path) {
        String fileName = path.getFileName().toString();
        if (!super.doFilter(path)) return false;
        if (Stream.of(ALLOWED_EXTENSIONS).anyMatch(fileName::endsWith)) return true;
        if (!this.libraryItemTypeService.getItemTypes().stream().anyMatch(type -> type.isAllowedInXlib(this.getSourceManager().getWorkFolder().toPath().relativize(path).toString()))) return false;
        return true;
    }

    public static class Factory
    extends TaskFactory {
        LibraryItemTypeService libraryItemTypeService;

        public Factory(LibraryItemTypeService libraryItemTypeService, Double priority) {
            super(priority);
            this.libraryItemTypeService = libraryItemTypeService;
        }

        @Override
        public Boolean matchId(String id) {
            return id.equals(TASK_ID);
        }

        @Override
        public CacheAbleTask createTask(String id, SourceManager sourceManager) {
            return new XlibZipTask(sourceManager, id, this.libraryItemTypeService);
        }
    }
}

