/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi;

import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class BPMNComponentsTask
extends XSLTTask {
    public static Boolean select(String id) {
        return id.startsWith(Folders.model) && id.endsWith(Extensions._bpmn_components_xml);
    }

    public BPMNComponentsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getTransformerId() {
        return "model.xmi.bpmn.components";
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(Files.project_xml);
        XumlProject projectDocument = ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
        result.add(Files.model__PROJECTNAME_configuration_service_xmiTransformationModel_rId_xml(projectDocument.getName()));
        try {
            Path projectPath = this.getSourceManager().getProjectFolder().toPath();
            this.sourceManager.getSourceFilesStream().filter(path -> {
                String s = projectPath.relativize((Path)path).toString().replace(System.getProperty("file.separator"), Folders.SEPARATOR);
                return s.endsWith(Extensions._bpmn_json);
            }).forEach(path -> result.add(Files.bpmn__PROCESS_bpmn_service_xmiTransformationModel_rId_xml(path.getFileName().toString().replace(Extensions._bpmn_json, ""))));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

