/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.libraries.JarAnnotationsMap;
import ch.e2e.builder.compiler.build.tasks.source.JarAnnotationsMapSource;
import ch.e2e.builder.compiler.build.tasks.source.JarSourceFile;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class JarImportAnnotationsTask
extends CacheAbleTask
implements JarAnnotationsMapSource,
XSLTTransformSource {
    JarAnnotationsMap jarAnnotationsMap = null;

    public static Boolean select(String id) {
        return id.startsWith(Folders.jars_) && id.endsWith(Extensions._annotations_xml);
    }

    public JarImportAnnotationsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(Folders.jars_ + this.getDestinationFileNameWithoutExtension() + Extensions._jar);
        return result;
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._annotations_xml;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            this.jarAnnotationsMap = new JarAnnotationsMap();
            JarSourceFile source = (JarSourceFile)this.sourceManager.getSource(Folders.jars_ + this.getDestinationFileNameWithoutExtension() + Extensions._jar);
            this.jarAnnotationsMap.setMap(source.getAnnotations());
            DOMResult result = new DOMResult();
            JaxbUtils.marshalXml((Object)this.jarAnnotationsMap, result);
            DomUtilities.serialize((File)this.getDestinationFile(), (Node)result.getNode(), (boolean)true);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public JarAnnotationsMap getJarAnnotationsMap() {
        if (this.jarAnnotationsMap == null) {
            if (!this.isExecuted()) {
                this.execute();
            }
            if (this.isUpToDate()) {
                try {
                    this.jarAnnotationsMap = JaxbUtils.unmarshalXml(this.getDestinationFile(), JarAnnotationsMap.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.jarAnnotationsMap;
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

