/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.assetRepository;

import ch.e2e.builder.compiler.build.Logging;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.utils.EnvUtils;
import ch.e2e.builder.compiler.utils.TokenManager;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class AssetRepositoryService {
    private static final String PROTOCOL = EnvUtils.get("ASSET_REPOSITORY_SERVICE_PROTOCOL", "http");
    private static final String HOSTNAME = EnvUtils.get("ASSET_REPOSITORY_SERVICE_HOSTNAME", "asset-repository-service");
    private static final int PORT = EnvUtils.get("ASSET_REPOSITORY_SERVICE_PORT", 8080);
    private static final String BASE_PATH = "assets";
    static final UriBuilder BASE_URI = UriBuilder.fromPath((String)"assets").scheme(PROTOCOL).host(HOSTNAME).port(PORT);
    private final WebTarget webTarget;
    private final TokenManager tokenManager;
    private final Logger logger;

    public AssetRepositoryService(Client client, TokenManager tokenManager) {
        this(client, tokenManager, Logging.logger);
    }

    public AssetRepositoryService(Client client, TokenManager tokenManager, Logger logger) {
        this.webTarget = client.target(BASE_URI);
        this.tokenManager = tokenManager;
        this.logger = logger;
    }

    public InputStream getXlib(String namespace, String name, String version) {
        return this.getArtifact(namespace, name, version, name + Extensions._xlib);
    }

    public InputStream getArtifact(String namespace, String name, String version, String artifact) {
        Response response = this.webTarget.path(namespace).path(name).path(version).path(artifact).request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).header("Authorization", (Object)this.tokenManager.getBearerTokenString()).get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            try {
                return (InputStream)response.readEntity(InputStream.class);
            }
            catch (Exception e) {
                this.logger.warning(String.format("Failed to get artifact (namespace: %s, name: %s, version: %s, artifact: %s) (%s)", namespace, name, version, artifact, e.getMessage()));
            }
        } else {
            Response.StatusType status = response.getStatusInfo();
            this.logger.warning(String.format("Failed to get artifact (namespace: %s, name: %s, version: %s, artifact: %s) (%s %s)", namespace, name, version, artifact, status.getStatusCode(), status.getReasonPhrase()));
        }
        return null;
    }
}

