/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.tree.menu;

import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.event.TestcaseEvent;
import ch.e2e.builder.trace.tree.RefreshAsynchronousTreeEvent;
import ch.e2e.builder.traceviewer.testcase.AbstractAsynchronousTestcase;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.EventObject;

public class DeleteAsynchronousTestcaseExecuter
implements EventExecuter {
    private E2EBuilderModule module;

    public DeleteAsynchronousTestcaseExecuter(E2EBuilderModule module) {
        this.module = module;
    }

    public void execute(EventObject event) throws EventExecutionVetoException {
        AbstractAsynchronousTestcase testcase = (AbstractAsynchronousTestcase)((TestcaseEvent)event).getTestcaseObject();
        TestcaseContainer parent = testcase.getParent();
        String name = testcase.getIdentifier().toString();
        String question = this.module.getTranslation("testcase.delete.question.message");
        question = StringTools.replaceProperty((String)question, (String)"testcase", (String)name);
        String title = this.module.getTranslation("testcase.delete.question.title");
        title = StringTools.replaceProperty((String)title, (String)"testcase", (String)name);
        String subtitle = this.module.getTranslation("testcase.delete.question.subtitle");
        if (E2EBuilderQuestionDialog.doYesNoQuestion((String)title, (String)(subtitle = StringTools.replaceProperty((String)subtitle, (String)"testcase", (String)name)), (String)question)) {
            try {
                parent.delete((TestcaseObject)testcase);
            }
            catch (FilesNotDeletedException e) {
                for (File file : e.getFiles()) {
                    String msg = this.module.getTranslation("could.not.delete." + (file.isDirectory() ? "directory" : "file"));
                    this.module.showError(StringTools.replaceProperty((String)msg, (String)"file", (String)file.getPath()));
                }
            }
            EventController.fire((EventObject)new RefreshAsynchronousTreeEvent((Object)this, (TestcaseObject)parent));
        }
    }
}

