/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing.tree;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.testcase.AbstractTestcaseRootTreeModel;
import ch.e2e.builder.trace.gui.testcase.ViewTestcaseParameterAction;
import ch.e2e.builder.trace.gui.tree.AdapterPopupMenu;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeEvent;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeListener;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcaseRoot;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.TestcaseRoot;
import ch.e2e.builder.trace.testcase.TestcaseWatch;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.Error;
import ch.e2e.builder.trace.testcase.uml.InspectionObject;
import ch.e2e.builder.trace.testcase.uml.Message;
import ch.e2e.builder.trace.testcase.uml.TraceError;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.traceviewer.swing.testcase.AsyncErrorInfo;
import ch.e2e.builder.traceviewer.swing.testcase.TraceErrorInfo;
import ch.e2e.builder.traceviewer.swing.tree.AsyncErrorPopupMenu;
import ch.e2e.builder.traceviewer.swing.tree.AsynchronousFolderPopupMenu;
import ch.e2e.builder.traceviewer.swing.tree.AsynchronousTestcaseFolderPopupMenu;
import ch.e2e.builder.traceviewer.swing.tree.AsynchronousTestcasePopupMenu;
import ch.e2e.builder.traceviewer.swing.tree.ErrorPopupMenu;
import ch.e2e.builder.traceviewer.swing.tree.InspectionListPopupMenu;
import ch.e2e.builder.traceviewer.swing.tree.MessagePopupMenu;
import ch.e2e.builder.traceviewer.swing.tree.OperationPopupMenu;
import ch.e2e.builder.traceviewer.swing.tree.TestcasePopupMenu;
import ch.e2e.builder.traceviewer.swing.tree.WsdlPopupMenu;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.AsynchronousClass;
import ch.e2e.io.ZipUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestcaseTreeModel
extends AbstractTestcaseRootTreeModel {
    private ErrorPopupMenu errorPopupMenu = null;
    private AsyncErrorPopupMenu asyncErrorPopupMenu = null;
    private MessagePopupMenu messagePopupMenu = null;
    private WsdlPopupMenu wsdlPopupMenu = null;
    private OperationPopupMenu operationPopupMenu = null;
    private TestcasePopupMenu testcasePopupMenu = null;
    private InspectionListPopupMenu inspectionPopupMenu = null;
    private AsynchronousFolderPopupMenu asynchronousFolderPopupMenu;
    private AsynchronousTestcaseFolderPopupMenu asynchronousTestcaseFolderPopupMenu;
    private AsynchronousTestcasePopupMenu asynchronousTestcasePopupMenu;
    private AdapterPopupMenu adapterPopupMenu;
    private E2EBuilderModule traceViewer;
    private TestcaseTreeListener testcaseListener;
    private RunTestcaseAction runTestcaseAction;
    private PreferencesAction preferencesAction;
    private ViewTestcaseParameterAction viewParameterAction;
    private TraceErrorAction traceErrorAction;
    private AsyncErrorAction asyncErrorAction;
    private MessageAction messageAction;

    public TestcaseTreeModel(TestcaseRoot root, E2EBuilderModule traceViewer, TestcaseTreeListener testcaseListener) {
        super(root, traceViewer);
        this.traceViewer = traceViewer;
        this.testcaseListener = testcaseListener;
        this.wsdlPopupMenu = new WsdlPopupMenu(traceViewer);
        this.operationPopupMenu = new OperationPopupMenu(traceViewer, testcaseListener);
        this.testcasePopupMenu = new TestcasePopupMenu(traceViewer, testcaseListener);
        if (root instanceof AbstractSynchronousTestcaseRoot) {
            this.inspectionPopupMenu = new InspectionListPopupMenu(this, traceViewer);
            this.adapterPopupMenu = new AdapterPopupMenu(traceViewer, testcaseListener);
        }
        this.runTestcaseAction = new RunTestcaseAction();
        this.preferencesAction = new PreferencesAction();
        this.viewParameterAction = new ViewTestcaseParameterAction(traceViewer);
        this.asynchronousFolderPopupMenu = new AsynchronousFolderPopupMenu(traceViewer);
        this.asynchronousTestcasePopupMenu = new AsynchronousTestcasePopupMenu(traceViewer);
        this.asynchronousTestcaseFolderPopupMenu = new AsynchronousTestcaseFolderPopupMenu(traceViewer);
        this.errorPopupMenu = new ErrorPopupMenu(traceViewer);
        this.traceErrorAction = new TraceErrorAction(traceViewer);
        this.asyncErrorPopupMenu = new AsyncErrorPopupMenu(traceViewer);
        this.asyncErrorAction = new AsyncErrorAction(traceViewer);
        this.messagePopupMenu = new MessagePopupMenu(traceViewer);
        this.messageAction = new MessageAction(traceViewer);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getType(Object value) {
        int result = value instanceof AsynchronousClass ? ((AsynchronousClass)value).getType() : super.getType(value);
        return result;
    }

    public boolean isEditable(Object node) {
        return false;
    }

    public JPopupMenu getPopupMenu(TreePath[] path) {
        Object result = null;
        if (path != null && path.length > 0) {
            Object value = path[0].getLastPathComponent();
            if (value instanceof InspectionObject) {
                if (this.inspectionPopupMenu != null) {
                    this.inspectionPopupMenu.setInspectionObject(path[0]);
                }
                result = this.inspectionPopupMenu;
            } else {
                switch (this.getType(value)) {
                    case 2: {
                        this.wsdlPopupMenu.setPath(path[0]);
                        result = this.wsdlPopupMenu;
                        break;
                    }
                    case 5: {
                        this.operationPopupMenu.setPath(path[0]);
                        result = this.operationPopupMenu;
                        break;
                    }
                    case 10003: 
                    case 10049: 
                    case 20002: 
                    case 20048: {
                        if (this.adapterPopupMenu != null) {
                            this.adapterPopupMenu.setPath(path[0]);
                        }
                        result = this.adapterPopupMenu;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: {
                        this.testcasePopupMenu.setPath(path[0]);
                        result = this.testcasePopupMenu;
                        break;
                    }
                    case 20: {
                        this.asynchronousFolderPopupMenu.setPath(path[0]);
                        result = this.asynchronousFolderPopupMenu;
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 27: 
                    case 28: 
                    case 29: {
                        this.asynchronousTestcaseFolderPopupMenu.setPath(path[0]);
                        result = this.asynchronousTestcaseFolderPopupMenu;
                        break;
                    }
                    case 24: 
                    case 40: {
                        this.asynchronousTestcasePopupMenu.setPath(path[0]);
                        result = this.asynchronousTestcasePopupMenu;
                        break;
                    }
                    case 10020: {
                        this.errorPopupMenu.setTraceError((TraceError)value);
                        result = this.errorPopupMenu;
                        break;
                    }
                    case 10038: {
                        this.asyncErrorPopupMenu.setError((Error)value);
                        result = this.asyncErrorPopupMenu;
                        break;
                    }
                    case 10041: {
                        this.messagePopupMenu.setMessage((Message)value);
                        result = this.messagePopupMenu;
                    }
                }
            }
        }
        return result;
    }

    public String getTooltip(Object value) {
        String tooltip = null;
        if (value instanceof Testcase) {
            tooltip = ((Testcase)value).getDescription();
        } else if (value instanceof AbstractAsyncTestcaseFolder) {
            tooltip = this.traceViewer.getTranslation(((AbstractAsyncTestcaseFolder)value).getTooltip(), "");
        } else if (value instanceof TraceError) {
            tooltip = ((TraceError)value).getMessage();
        }
        return tooltip == null || tooltip.isEmpty() ? "no description" : tooltip;
    }

    public TestcaseWatch getWatch(Testcase testcase, Data data) {
        TestcaseWatch watch = null;
        try {
            Document valueDocument = ZipUtilities.getZippedDocumentFromFile((File)testcase.getIOFile(), (String)data.getValue());
            Element valueElement = (Element)valueDocument.getDocumentElement().getFirstChild();
            watch = new TestcaseWatch(null, -1, valueElement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return watch;
    }

    public ActionListener getExecuteAction(TreePath[] path) {
        ActionListener result = null;
        if (path != null && path.length > 0) {
            Object value = path[0].getLastPathComponent();
            if (value instanceof AbstractSynchronousTestcase) {
                this.preferencesAction.setTestcase((AbstractSynchronousTestcase)value);
                result = this.preferencesAction;
            } else if (value instanceof Data) {
                this.viewParameterAction.setParameter((TestcaseParameter)this.getWatch(this.findTestcase(path[0]), (Data)value));
                result = this.viewParameterAction;
            } else if (value instanceof TraceError) {
                this.traceErrorAction.setTraceError((TraceError)value);
                result = this.traceErrorAction;
            } else if (value instanceof Error) {
                this.asyncErrorAction.setError((Error)value);
                result = this.asyncErrorAction;
            } else if (value instanceof Message) {
                this.messageAction.setMessage((Message)value);
                result = this.messageAction;
            }
        }
        return result;
    }

    public void fireTreeNodesChanged(TreePath path, int index) {
        if (path != null) {
            int[] childIndices = new int[]{index};
            super.fireTreeNodesChanged(path, childIndices, null);
        }
    }

    public void fireTreeNodesInserted(TreePath path, int index) {
        if (path != null) {
            int[] childIndices = new int[]{index};
            super.fireTreeNodesInserted(path, childIndices, null);
        }
    }

    public void fireTreeNodesRemoved(TreePath path, int index) {
        if (path != null) {
            int[] childIndices = new int[]{index};
            super.fireTreeNodesRemoved(path, childIndices, null);
        }
    }

    public String toString(Object value) {
        String result = super.toString(value);
        if (value instanceof AbstractAsyncTestcaseFolder) {
            String tracingInfo = ((AbstractAsyncTestcaseFolder)value).getTracingInfo();
            result = result + " (" + this.traceViewer.getTranslation(tracingInfo, tracingInfo) + ")";
        } else if (value instanceof AbstractSynchronousTestcase && ((AbstractSynchronousTestcase)value).isOutdated()) {
            result = result + " (" + this.traceViewer.getTranslation("testcase.tree.renderer.outdated") + ")";
        }
        return result;
    }

    public UmlObject find(String id) {
        Iterator iterator = this.depthFirstIterator(this.getRoot());
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof UmlObject) || !id.equals(((UmlObject)next).getOriginalName())) continue;
            return (UmlObject)next;
        }
        return null;
    }

    private Testcase findTestcase(TreePath path) {
        Testcase result = null;
        Object[] pathObjects = path.getPath();
        for (int i = pathObjects.length - 1; i > -1 && result == null; --i) {
            if (!(pathObjects[i] instanceof Testcase)) continue;
            result = (Testcase)pathObjects[i];
        }
        return result;
    }

    private static class MessageAction
    implements ActionListener {
        private E2EBuilderModule module;
        private Message message;

        public MessageAction(E2EBuilderModule module) {
            this.module = module;
        }

        public void setMessage(Message message) {
            this.message = message;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AsyncErrorInfo.show(this.message, this.module);
        }
    }

    private static class AsyncErrorAction
    implements ActionListener {
        private E2EBuilderModule module;
        private Error error;

        public AsyncErrorAction(E2EBuilderModule module) {
            this.module = module;
        }

        public void setError(Error error) {
            this.error = error;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AsyncErrorInfo.show(this.error, this.module);
        }
    }

    private static class TraceErrorAction
    implements ActionListener {
        private E2EBuilderModule module;
        private TraceError traceError;

        public TraceErrorAction(E2EBuilderModule module) {
            this.module = module;
        }

        public void setTraceError(TraceError traceError) {
            this.traceError = traceError;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TraceErrorInfo.show(this.traceError, this.module);
        }
    }

    private class PreferencesAction
    implements ActionListener {
        private AbstractSynchronousTestcase testcase;

        private PreferencesAction() {
        }

        public void setTestcase(AbstractSynchronousTestcase testcase) {
            this.testcase = testcase;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TestcaseTreeModel.this.testcaseListener.editPreferences(new TestcaseTreeEvent((Object)this, this.testcase));
        }
    }

    private class RunTestcaseAction
    implements ActionListener {
        private AbstractSynchronousTestcase testcase;

        private RunTestcaseAction() {
        }

        public void setTestcase(AbstractSynchronousTestcase testcase) {
            this.testcase = testcase;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TestcaseTreeModel.this.testcaseListener.runTestcase(new TestcaseTreeEvent((Object)this, this.testcase));
        }
    }
}

