/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.IntPredicate;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.NamedTimeZone;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.One;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ZeroOrMore;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.TinyAttributeImpl;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.tree.util.ProcInstParser;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;

public class Extensions {
    private Extensions() {
    }

    public static void pauseTracing(XPathContext c) {
        c.getController().pauseTracing(true);
    }

    public static void resumeTracing(XPathContext c) {
        c.getController().pauseTracing(false);
    }

    public static One<StringValue> systemId(XPathContext c) throws XPathException {
        Item<?> item = c.getContextItem();
        if (item == null) {
            XPathException e = new XPathException("The context item for saxon:systemId() is absent");
            e.setXPathContext(c);
            throw e;
        }
        if (item instanceof NodeInfo) {
            return One.string(((NodeInfo)item).getSystemId());
        }
        return One.string("");
    }

    public static One<IntegerValue> lineNumber(XPathContext c) {
        Item<?> item = c.getContextItem();
        if (item instanceof NodeInfo) {
            return One.integer(((NodeInfo)item).getLineNumber());
        }
        return One.integer(-1L);
    }

    public static One<IntegerValue> lineNumber(ZeroOrOne<NodeInfo> node) {
        NodeInfo n = node.head();
        if (n == null) {
            return One.integer(-1L);
        }
        return One.integer(n.getLineNumber());
    }

    public static One<IntegerValue> columnNumber(XPathContext c) {
        Object item = c.getCurrentIterator().current();
        if (item instanceof NodeInfo) {
            return One.integer(((NodeInfo)item).getColumnNumber());
        }
        return One.integer(-1L);
    }

    public static One<IntegerValue> columnNumber(ZeroOrOne<NodeInfo> node) {
        NodeInfo n = node.head();
        if (n == null) {
            return One.integer(-1L);
        }
        return One.integer(n.getColumnNumber());
    }

    public static ZeroOrOne<NodeInfo> discardDocument(XPathContext context, ZeroOrOne<NodeInfo> document) {
        NodeInfo doc = document.head();
        if (doc == null) {
            return new ZeroOrOne<Object>(null);
        }
        Controller c = context.getController();
        String uri = c.getDocumentPool().getDocumentURI(doc);
        if (uri != null && c instanceof XsltController) {
            ((XsltController)c).removeUnavailableOutputDestination(new DocumentURI(uri));
        }
        c.getDocumentPool().discard(doc.getTreeInfo());
        return new ZeroOrOne<NodeInfo>(doc);
    }

    public static One<BooleanValue> hasSameNodes(ZeroOrMore<NodeInfo> p1, ZeroOrMore<NodeInfo> p2) throws XPathException {
        NodeInfo n2;
        NodeInfo n1;
        SequenceIterator e1 = p1.iterate();
        SequenceIterator e2 = p2.iterate();
        if (e1 == null) {
            e1 = EmptyIterator.getInstance();
        }
        if (e2 == null) {
            e2 = EmptyIterator.getInstance();
        }
        do {
            n1 = (NodeInfo)e1.next();
            n2 = (NodeInfo)e2.next();
            if (n1 != null && n2 != null) continue;
            return One.bool(n1 == n2);
        } while (n1.equals(n2));
        return One.bool(false);
    }

    public static One<StringValue> path(XPathContext context, One<NodeInfo> node) {
        return One.string(Navigator.getPath((NodeInfo)node.head(), context));
    }

    public static One<StringValue> path(XPathContext c) throws XPathException {
        Item<?> item = c.getContextItem();
        if (item == null) {
            XPathException e = new XPathException("The context item for saxon:path() is not set");
            e.setXPathContext(c);
            throw e;
        }
        if (item instanceof NodeInfo) {
            return One.string(Navigator.getPath((NodeInfo)item, c));
        }
        return One.string("");
    }

    public static ZeroOrOne<QNameValue> typeAnnotation(XPathContext context, ZeroOrOne<Item<?>> value) {
        Item<?> item = value.head();
        if (item == null) {
            return ZeroOrOne.empty();
        }
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            SchemaType type = node.getSchemaType();
            if (type == null) {
                return ZeroOrOne.empty();
            }
            String uri = type.getTargetNamespace();
            String prefix = uri.equals("http://www.w3.org/2001/XMLSchema") ? "xs" : "";
            return new ZeroOrOne<QNameValue>(new QNameValue(prefix, uri, type.getName()));
        }
        if (item instanceof AtomicValue) {
            AtomicType type = ((AtomicValue)item).getItemType();
            String uri = type.getTargetNamespace();
            String prefix = uri.equals("http://www.w3.org/2001/XMLSchema") ? "xs" : "";
            return new ZeroOrOne<QNameValue>(new QNameValue(prefix, uri, type.getName()));
        }
        if (item instanceof ExternalObject) {
            return new ZeroOrOne<QNameValue>(new QNameValue(JavaExternalObjectType.classNameToQName(((ExternalObject)item).getObject().getClass().getName()), BuiltInAtomicType.QNAME));
        }
        return ZeroOrOne.empty();
    }

    public static XPathContext getContext(XPathContext c) {
        return c;
    }

    public static Controller getController(XPathContext c) {
        return c.getController();
    }

    public static Configuration getConfiguration(XPathContext c) {
        return c.getConfiguration();
    }

    public static One<StringValue> printStack(XPathContext c) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        StandardLogger logger = new StandardLogger();
        logger.setPrintStream(new PrintStream(baos));
        StandardErrorListener.printStackTrace(c, logger, 2);
        return One.string(baos.toString().replace("\r", ""));
    }

    public static ZeroOrMore<Item<?>> eager(ZeroOrMore<Item<?>> value) {
        return value;
    }

    public static ZeroOrOne<StringValue> getPseudoAttribute(XPathContext c, One<StringValue> name) throws XPathException {
        Item<?> pi = c.getContextItem();
        if (pi == null) {
            XPathException e = new XPathException("The context item for saxon:getPseudoAttribute() is not set");
            e.setXPathContext(c);
            throw e;
        }
        String value = ProcInstParser.getPseudoAttribute(pi.getStringValue(), ((StringValue)name.head()).getStringValue());
        return new ZeroOrOne<StringValue>(value == null ? null : new StringValue(value));
    }

    public static ZeroOrMore<IntegerValue> stringToUtf8(One<StringValue> in) {
        String s = ((StringValue)in.head()).getStringValue();
        ArrayList<Int64Value> list = new ArrayList<Int64Value>(s.length() * 2);
        byte[] octets = new byte[4];
        for (int i = 0; i < s.length(); ++i) {
            int used = UTF8CharacterSet.getUTF8Encoding(s.charAt(i), i + 1 < s.length() ? s.charAt(i + 1) : (char)'\u0000', octets);
            for (int j = 0; j < used; ++j) {
                list.add(new Int64Value(0xFF & octets[j]));
            }
        }
        return new ZeroOrMore<IntegerValue>(list);
    }

    public static ZeroOrOne<Base64BinaryValue> octetsToBase64Binary(ZeroOrMore<IntegerValue> in) throws XPathException {
        if (in == null) {
            return ZeroOrOne.empty();
        }
        return new ZeroOrOne<Base64BinaryValue>(new Base64BinaryValue(Extensions.toByteArray(in)));
    }

    private static byte[] toByteArray(ZeroOrMore<IntegerValue> in) throws XPathException {
        byte[] octets = new byte[in.getLength()];
        for (int i = 0; i < octets.length; ++i) {
            long l = in.itemAt(i).longValue();
            if (l < 0L || l > 255L) {
                throw new XPathException("Integers in input sequence must be in range 0-255", "SXJX0001");
            }
            octets[i] = (byte)l;
        }
        return octets;
    }

    public static ZeroOrOne<HexBinaryValue> octetsToHexBinary(ZeroOrMore<IntegerValue> in) throws XPathException {
        if (in == null) {
            return ZeroOrOne.empty();
        }
        return new ZeroOrOne<HexBinaryValue>(new HexBinaryValue(Extensions.toByteArray(in)));
    }

    public static byte[] base64BinaryToOctets(One<Base64BinaryValue> in) {
        return ((Base64BinaryValue)in.head()).getBinaryValue();
    }

    public static byte[] hexBinaryToOctets(One<HexBinaryValue> in) {
        return ((HexBinaryValue)in.head()).getBinaryValue();
    }

    public static ZeroOrOne<StringValue> base64BinaryToString(XPathContext context, ZeroOrOne<Base64BinaryValue> in, One<StringValue> encoding) throws XPathException {
        try {
            if (in.head() == null) {
                return ZeroOrOne.empty();
            }
            byte[] bytes = in.head().getBinaryValue();
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            InputStreamReader reader = new InputStreamReader((InputStream)stream, ((StringValue)encoding.head()).getStringValue());
            char[] array = new char[bytes.length];
            int used = reader.read(array, 0, array.length);
            Extensions.checkBytes(array, 0, used, context.getConfiguration().getValidCharacterChecker());
            return new ZeroOrOne<StringValue>(new StringValue(new String(array, 0, used)));
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static ZeroOrOne<Base64BinaryValue> stringToBase64Binary(ZeroOrOne<StringValue> in, One<StringValue> encoding) throws IOException {
        if (in.head() == null) {
            return ZeroOrOne.empty();
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(in.head().getStringLength());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, ((StringValue)encoding.head()).getStringValue());
        writer.write(in.head().getStringValue());
        writer.close();
        byte[] bytes = stream.toByteArray();
        return new ZeroOrOne<Base64BinaryValue>(new Base64BinaryValue(bytes));
    }

    public static ZeroOrOne<StringValue> hexBinaryToString(XPathContext context, ZeroOrOne<HexBinaryValue> in, One<StringValue> encoding) throws XPathException {
        try {
            if (in.head() == null) {
                return ZeroOrOne.empty();
            }
            byte[] bytes = in.head().getBinaryValue();
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            InputStreamReader reader = new InputStreamReader((InputStream)stream, ((StringValue)encoding.head()).getStringValue());
            char[] array = new char[bytes.length];
            int used = reader.read(array, 0, array.length);
            Extensions.checkBytes(array, 0, used, context.getConfiguration().getValidCharacterChecker());
            return new ZeroOrOne<StringValue>(new StringValue(new String(array, 0, used)));
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static One<Base64BinaryValue> readBinaryResource(One<StringValue> uri) throws XPathException {
        try {
            byte[] buffer;
            int b;
            InputStream stream;
            String arg = ((StringValue)uri.head()).getStringValue();
            URL url = new URL(arg);
            try {
                stream = url.openStream();
            }
            catch (IllegalArgumentException e) {
                throw new XPathException("saxon:read-binary-resource - invalid URL " + arg, "SXJE0053");
            }
            ArrayList<byte[]> buffers = new ArrayList<byte[]>();
            int len = 0;
            while ((b = stream.read(buffer = new byte[4096])) >= 0) {
                if (b < 4096) {
                    buffer = Arrays.copyOf(buffer, b);
                }
                buffers.add(buffer);
                len += b;
            }
            byte[] result = new byte[len];
            int offset = 0;
            for (byte[] buffer2 : buffers) {
                System.arraycopy(buffer2, 0, result, offset, buffer2.length);
                offset += buffer2.length;
            }
            return new One<Base64BinaryValue>(new Base64BinaryValue(result));
        }
        catch (IOException e) {
            throw new XPathException("saxon:read-binary-resource: I/O error: " + e.getMessage(), "SXJE0053");
        }
    }

    private static void checkBytes(char[] array, int start, int end, IntPredicate checker) throws XPathException {
        int ch32 = UTF16CharacterSet.firstInvalidChar(new CharSlice(array, start, end - start), checker);
        if (ch32 != -1) {
            XPathException err = new XPathException("The byte sequence contains a character not allowed by XML (hex " + Integer.toHexString(ch32) + ')');
            err.setErrorCode("XTDE1180");
            throw err;
        }
    }

    public static ZeroOrOne<HexBinaryValue> stringToHexBinary(ZeroOrOne<StringValue> in, One<StringValue> encoding) throws XPathException {
        try {
            if (in.head() == null) {
                return ZeroOrOne.empty();
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream(in.head().getStringLength());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, ((StringValue)encoding.head()).getStringValue());
            writer.write(in.head().getStringValue());
            writer.close();
            byte[] bytes = stream.toByteArray();
            return new ZeroOrOne<HexBinaryValue>(new HexBinaryValue(bytes));
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static boolean validCharacter(XPathContext c, int in) {
        return c.getConfiguration().getValidCharacterChecker().test(in);
    }

    public static One<NodeInfo> namespaceNode(XPathContext context, One<StringValue> prefix, One<StringValue> uri) throws XPathException {
        String prefix0 = ((StringValue)prefix.head()).getStringValue();
        String uri0 = ((StringValue)uri.head()).getStringValue();
        if (!prefix0.isEmpty() && !NameChecker.isValidNCName(prefix0)) {
            throw new XPathException("Namespace prefix " + Err.wrap(prefix0) + " is not a valid NCName");
        }
        if (uri0.isEmpty()) {
            throw new XPathException("URI of namespace node must not be empty");
        }
        Orphan node = new Orphan(context.getConfiguration());
        node.setNodeKind((short)13);
        node.setNodeName(new NoNamespaceName(prefix0));
        node.setStringValue(uri0);
        return new One<NodeInfo>(node);
    }

    public static ZeroOrMore<StringValue> unparsedEntities(One<NodeInfo> doc) {
        Iterator<String> names = ((NodeInfo)doc.head()).getTreeInfo().getUnparsedEntityNames();
        ArrayList<StringValue> result = new ArrayList<StringValue>();
        while (names.hasNext()) {
            result.add(new StringValue(names.next()));
        }
        return new ZeroOrMore<StringValue>(result);
    }

    public static ZeroOrOne<BooleanValue> inSummerTime(XPathContext context, One<DateTimeValue> date, One<StringValue> region) {
        Boolean b;
        DateTimeValue dt = (DateTimeValue)date.head();
        if (!dt.hasTimezone()) {
            dt = dt.adjustTimezone(context.getImplicitTimezone());
        }
        if ((b = NamedTimeZone.inSummerTime(dt, ((StringValue)region.head()).getStringValue())) == null) {
            return ZeroOrOne.empty();
        }
        return new ZeroOrOne<BooleanValue>(BooleanValue.get(b));
    }

    public static ZeroOrOne<DateTimeValue> adjustToCivilTime(XPathContext context, ZeroOrOne<DateTimeValue> date, One<StringValue> region) {
        DateTimeValue dt = date.head();
        if (dt == null) {
            return ZeroOrOne.empty();
        }
        if (!dt.hasTimezone()) {
            dt = dt.adjustTimezone(context.getImplicitTimezone());
        }
        int ms = NamedTimeZone.civilTimeOffset(dt, ((StringValue)region.head()).getStringValue());
        return new ZeroOrOne<DateTimeValue>(dt.adjustTimezone(ms / 60000));
    }

    public static ZeroOrOne<QNameValue> currentModeName(XPathContext context) {
        Component.M mode = context.getCurrentMode();
        if (mode == null) {
            return ZeroOrOne.empty();
        }
        StructuredQName name = mode.getActor().getModeName();
        if (name == null || name.equals(Mode.UNNAMED_MODE_NAME)) {
            return ZeroOrOne.empty();
        }
        return new ZeroOrOne<QNameValue>(new QNameValue(name, BuiltInAtomicType.QNAME));
    }

    public static ZeroOrOne<BooleanValue> isDefaulted(ZeroOrOne<NodeInfo> arg) {
        NodeInfo node = arg.head();
        if (node == null) {
            return ZeroOrOne.empty();
        }
        boolean result = node instanceof TinyAttributeImpl && ((TinyAttributeImpl)node).isDefaultedAttribute();
        return new One<BooleanValue>(BooleanValue.get(result));
    }
}

