/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;

public class InputComboBox
extends JComboBox
implements InputField,
ItemListener {
    private InputFieldListener listener;
    private Hashtable<Object, Object> items = new Hashtable();

    public InputComboBox() {
        this.addItemListener(this);
    }

    public InputComboBox(Vector items) {
        for (int i = 0; i < items.size(); ++i) {
            this.addItem(items.elementAt(i));
        }
        this.addItemListener(this);
    }

    public InputComboBox(Object[] items, Object[] itemIDs) {
        for (int i = 0; i < items.length; ++i) {
            this.addItem(items[i], itemIDs[i]);
        }
        this.addItemListener(this);
    }

    public void addItem(Object item) {
        super.addItem(item);
        this.items.put(item, item);
    }

    public void addItem(Object item, Object itemID) {
        super.addItem(item);
        this.items.put(itemID, item);
    }

    public void setItems(Collection list) {
        this.removeAllItems();
        this.items.clear();
        for (Object aList : list) {
            this.addItem(aList);
        }
    }

    public boolean containsItem(Object item) {
        return this.items.contains(item);
    }

    @Override
    public Object getContent() {
        Object item = this.getSelectedItem();
        if (item != null) {
            Enumeration<Object> elements = this.items.keys();
            while (elements.hasMoreElements()) {
                Object key = elements.nextElement();
                if (!item.equals(this.items.get(key))) continue;
                return key;
            }
        }
        return item;
    }

    @Override
    public void setContent(Object content) {
        this.setSelectedItem(content == null ? content : this.items.get(content));
    }

    @Override
    public void addInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.addListener(this.listener, listener);
    }

    @Override
    public void removeInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.removeListener(this.listener, listener);
    }

    public void fireInputField() {
        if (this.listener != null) {
            this.listener.inputFieldChanged(new InputFieldEvent(this));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireInputField();
    }
}

