/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types;

import ch.e2e.ant.gui.configuration.ConfigurationTools;
import ch.e2e.ant.gui.configuration.types.GuiElement;
import ch.e2e.ant.gui.configuration.types.PropertiesObject;
import ch.e2e.resource.Properties;
import ch.e2e.util.StringTools;
import java.awt.Color;
import javax.swing.JComponent;

public abstract class AbstractGuiElement
implements GuiElement,
PropertiesObject {
    private Properties properties;
    private String visibleIf;
    private String visibleUnless;
    private String os;
    private String fill = null;
    private String anchor = "northwest";
    private int top = 0;
    private int left = 0;
    private int bottom = 0;
    private int right = 0;
    private int gridwidth = -1;
    private Color foreground;
    private Color background;

    protected AbstractGuiElement() {
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        if (background != null) {
            this.setBackground(StringTools.createColorString((Color)background));
        }
    }

    public void setBackground(String background) {
        this.background = new Color(Integer.parseInt(background.substring(1), 16));
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(String foreground) {
        this.foreground = new Color(Integer.parseInt(foreground.substring(1), 16));
    }

    @Override
    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    @Override
    public int getAnchor() {
        return AbstractGuiElement.getAnchor(this.anchor);
    }

    public static int getAnchor(String anchor) {
        int result = anchor.equalsIgnoreCase("north") ? 11 : (anchor.equalsIgnoreCase("northeast") ? 12 : (anchor.equalsIgnoreCase("east") ? 13 : (anchor.equalsIgnoreCase("southeast") ? 14 : (anchor.equalsIgnoreCase("south") ? 15 : (anchor.equalsIgnoreCase("southwest") ? 16 : (anchor.equalsIgnoreCase("west") ? 17 : (anchor.equalsIgnoreCase("northwest") ? 18 : 10)))))));
        return result;
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    @Override
    public int getBottom() {
        return this.bottom;
    }

    @Override
    public void setLeft(int left) {
        this.left = left;
    }

    @Override
    public int getLeft() {
        return this.left;
    }

    @Override
    public void setRight(int right) {
        this.right = right;
    }

    @Override
    public int getRight() {
        return this.right;
    }

    @Override
    public void setTop(int top) {
        this.top = top;
    }

    @Override
    public int getTop() {
        return this.top;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setVisibleIf(String visibleIf) {
        this.visibleIf = visibleIf;
    }

    @Override
    public boolean isVisible() {
        boolean result = ConfigurationTools.checkOs(this.os);
        result &= this.visibleIf == null || this.properties.containsKey((Object)this.visibleIf);
        return result &= this.visibleUnless == null || !this.properties.containsKey((Object)this.visibleUnless);
    }

    public void setVisibleUnless(String unless) {
        this.visibleUnless = unless;
    }

    public void setOs(String os) {
        this.os = os;
    }

    @Override
    public int getFill() {
        if (this.fill == null) {
            this.fill = this.getFillDefault();
        }
        return AbstractGuiElement.getFill(this.fill);
    }

    public String getFillDefault() {
        return null;
    }

    public static int getFill(String fill) {
        int result = 0;
        if (fill != null) {
            if (fill.equalsIgnoreCase("horizontal")) {
                result = 2;
            } else if (fill.equalsIgnoreCase("vertical")) {
                result = 3;
            } else if (fill.equalsIgnoreCase("both")) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public void setFill(String fill) {
        if (this.fill == null) {
            this.fill = fill;
        }
    }

    @Override
    public int getGridwidth() {
        return this.gridwidth > 0 ? this.gridwidth : 0;
    }

    @Override
    public void setGridwidth(int gridwidth) {
        this.gridwidth = gridwidth;
    }

    @Override
    public JComponent getComponent() {
        JComponent result = this.getGuiElement();
        if (this.getBackground() != null) {
            result.setBackground(this.getBackground());
        }
        if (this.getForeground() != null) {
            result.setForeground(this.getForeground());
        }
        return result;
    }

    public abstract JComponent getGuiElement();
}

