/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui;

import ch.e2e.ant.gui.AntConsole;
import ch.e2e.io.OutputDestination;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.tools.ant.BuildEvent;

public class AntConsoleImpl
extends JScrollPane
implements OutputDestination,
AntConsole {
    private int debugLevel = -1;
    private JTextArea antOutput;
    private int indent;
    private int lineHeight;
    private int lines;

    public AntConsoleImpl() {
        this(25, 80);
    }

    public AntConsoleImpl(int rows, int columns) {
        super(20, 30);
        this.setAutoscrolls(true);
        this.antOutput = new JTextArea(rows, columns);
        this.antOutput.setEditable(false);
        this.antOutput.setAutoscrolls(true);
        this.setViewportView(this.antOutput);
    }

    @Override
    public void setDebugLevel(String debugLevel) {
        this.debugLevel = this.createDebugLevel(debugLevel);
    }

    private int createDebugLevel(String debugLevel) {
        int result = -1;
        if (debugLevel.equalsIgnoreCase("debug")) {
            result = 4;
        } else if (debugLevel.equalsIgnoreCase("verbose")) {
            result = 3;
        } else if (debugLevel.equalsIgnoreCase("info")) {
            result = 2;
        } else if (debugLevel.equalsIgnoreCase("warn")) {
            result = 1;
        } else if (debugLevel.equalsIgnoreCase("err")) {
            result = 0;
        } else if (debugLevel.equalsIgnoreCase("none")) {
            result = -1;
        }
        return result;
    }

    @Override
    public String getDebugLevel() {
        switch (this.debugLevel) {
            case 4: {
                return "debug";
            }
            case 3: {
                return "verbose";
            }
            case 2: {
                return "info";
            }
            case 1: {
                return "warn";
            }
            case 0: {
                return "err";
            }
        }
        return "none";
    }

    @Override
    public void addNotify() {
        super.addNotify();
        FontMetrics fm = this.getFontMetrics(this.antOutput.getFont());
        this.lineHeight = fm.getHeight();
        this.getVerticalScrollBar().setBlockIncrement(this.lineHeight);
    }

    @Override
    public void clear() {
        this.antOutput.setText("");
        this.lines = 0;
    }

    public void println() {
        this.antOutput.append("\n");
        ++this.lines;
    }

    public void println(String message) {
        this.antOutput.append(message + "\n");
        this.lines += new StringTokenizer(message, "\n").countTokens() + 1;
        this.antOutput.scrollRectToVisible(new Rectangle(0, (this.lines - 1) * this.lineHeight, 10, this.lines * this.lineHeight));
    }

    public void print(String message) {
        this.antOutput.append(message);
        this.lines += new StringTokenizer(message, "\n").countTokens();
        this.antOutput.scrollRectToVisible(new Rectangle(0, (this.lines - 1) * this.lineHeight, 10, this.lines * this.lineHeight));
    }

    public void taskStarted(BuildEvent event) {
        if (!event.getTask().getTaskName().equals("antcall")) {
            ++this.indent;
        }
    }

    public void taskFinished(BuildEvent event) {
        if (!event.getTask().getTaskName().equals("antcall")) {
            --this.indent;
        }
    }

    public void targetStarted(BuildEvent event) {
        this.printAntMessage(event.getTarget() + ":", 2);
        ++this.indent;
    }

    public void targetFinished(BuildEvent event) {
        --this.indent;
    }

    public void buildStarted(BuildEvent event) {
        this.printAntMessage("Starting build \"" + event.getProject().getName() + "\"", 2);
    }

    public void buildFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
        String taskName = event.getTask() == null ? "unknown task" : event.getTask().getTaskName();
        this.printAntMessage("[" + taskName + "] " + event.getMessage(), event.getPriority());
    }

    @Override
    public void log(String message, String debugLevel) {
        int debug = this.createDebugLevel(debugLevel);
        switch (debug) {
            case 1: {
                this.printAntMessage("WARNING: " + message, debug);
                break;
            }
            case 0: {
                this.printAntMessage("ERROR: " + message, debug);
                break;
            }
            default: {
                this.printAntMessage(message, debug);
            }
        }
    }

    private void printAntMessage(String message, int priority) {
        if (this.debugLevel >= priority) {
            StringBuffer messageBuf = new StringBuffer();
            for (int i = 0; i < this.indent; ++i) {
                messageBuf.append("  ");
            }
            this.println(messageBuf.toString() + message);
        }
    }
}

