/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.dataitem;

import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.BlobItem;
import ch.e2e.bridge.server.dataitem.BooleanItem;
import ch.e2e.bridge.server.dataitem.DateTimeItem;
import ch.e2e.bridge.server.dataitem.FloatItem;
import ch.e2e.bridge.server.dataitem.IntegerItem;
import ch.e2e.bridge.server.dataitem.Item;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.session.Session;

public class ComplexItem
extends Item {
    private Session session;

    private static native long nativeGetItem(long var0, long var2);

    private static native void nativeAddItem(long var0, long var2);

    private static native boolean nativeSetItem(long var0, long var2, long var4, boolean var6);

    private static native void nativeRemoveItem(long var0, long var2);

    private static native int nativeGetItemCount(long var0);

    ComplexItem(long nativeItem, Session session) {
        super(nativeItem);
        this.session = session;
    }

    public int size() {
        return ComplexItem.nativeGetItemCount(this.getNativeItem());
    }

    public ArrayItem getArrayItem(long index) {
        ArrayItem result;
        long nativeChildItem = ComplexItem.nativeGetItem(this.getNativeItem(), index);
        if (nativeChildItem == 0L) {
            result = null;
        } else {
            ComplexItem.nativeRelease(nativeChildItem);
            result = new ArrayItem(nativeChildItem, this.session);
        }
        return result;
    }

    public Item getItem(long index) {
        Item result;
        long nativeChildItem = ComplexItem.nativeGetItem(this.getNativeItem(), index);
        if (nativeChildItem == 0L) {
            result = null;
        } else {
            ComplexItem.nativeRelease(nativeChildItem);
            switch (ComplexItem.nativeGetTypeCode(nativeChildItem)) {
                case 1: {
                    result = new ArrayItem(nativeChildItem, this.session);
                    break;
                }
                case 2: {
                    result = new RecordItem(nativeChildItem, this.session);
                    break;
                }
                case 4: {
                    result = new BlobItem(nativeChildItem);
                    break;
                }
                case 5: {
                    result = new BooleanItem(nativeChildItem);
                    break;
                }
                case 6: {
                    result = new DateTimeItem(nativeChildItem);
                    break;
                }
                case 7: {
                    result = new FloatItem(nativeChildItem);
                    break;
                }
                case 8: {
                    result = new IntegerItem(nativeChildItem);
                    break;
                }
                case 9: {
                    result = new StringItem(nativeChildItem);
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    public void addItem(Item newItem) {
        ComplexItem.nativeAddItem(this.getNativeItem(), newItem == null ? 0L : newItem.getNativeItem());
    }

    public boolean setItem(long index, Item newItem, boolean replace) {
        return ComplexItem.nativeSetItem(this.getNativeItem(), index, newItem == null ? 0L : newItem.getNativeItem(), replace);
    }

    public void removeItem(long index) {
        ComplexItem.nativeRemoveItem(this.getNativeItem(), index);
    }

    public ArrayItem getArrayItem(int index) {
        ArrayItem result;
        long nativeChildItem = ComplexItem.nativeGetItem(this.getNativeItem(), index);
        if (nativeChildItem == 0L) {
            result = null;
        } else {
            ComplexItem.nativeRelease(nativeChildItem);
            result = new ArrayItem(nativeChildItem, this.session);
        }
        return result;
    }

    public ArrayItem getArrayItemCreateIfNotExists(int index) {
        ArrayItem result;
        long nativeChildItem = ComplexItem.nativeGetItem(this.getNativeItem(), index);
        if (nativeChildItem == 0L) {
            result = ItemFactory.createArrayItem(this.session);
            this.setItem(index, result, true);
        } else {
            ComplexItem.nativeRelease(nativeChildItem);
            result = new ArrayItem(nativeChildItem, this.session);
        }
        return result;
    }

    public RecordItem getRecordItem(int index) {
        return (RecordItem)this.getItem(index);
    }

    public RecordItem getRecordItemCreateIfNotExists(int index) {
        return this.getRecordItemCreateIfNotExists(index, null);
    }

    public RecordItem getRecordItemCreateIfNotExists(int index, String clazz) {
        RecordItem result = (RecordItem)this.getItem(index);
        if (result == null) {
            result = ItemFactory.createRecordItem(this.session, clazz);
            this.setItem(index, result, true);
        }
        return result;
    }

    public BlobItem getBlobItem(int index) {
        return (BlobItem)this.getItem(index);
    }

    public BlobItem getBlobItemCreateIfNotExists(int index) {
        BlobItem result = (BlobItem)this.getItem(index);
        if (result == null) {
            result = ItemFactory.createBlobItem(this.session);
            this.setItem(index, result, true);
        }
        return result;
    }

    public BooleanItem getBooleanItem(int index) {
        return (BooleanItem)this.getItem(index);
    }

    public BooleanItem getBooleanItemCreateIfNotExists(int index) {
        BooleanItem result = (BooleanItem)this.getItem(index);
        if (result == null) {
            result = ItemFactory.createBooleanItem(this.session);
            this.setItem(index, result, true);
        }
        return result;
    }

    public DateTimeItem getDateTimeItem(int index) {
        return (DateTimeItem)this.getItem(index);
    }

    public DateTimeItem getDateTimeItemCreateIfNotExists(int index) {
        DateTimeItem result = (DateTimeItem)this.getItem(index);
        if (result == null) {
            result = ItemFactory.createDateTimeItem(this.session);
            this.setItem(index, result, true);
        }
        return result;
    }

    public FloatItem getFloatItem(int index) {
        return (FloatItem)this.getItem(index);
    }

    public FloatItem getFloatItemCreateIfNotExists(int index) {
        FloatItem result = (FloatItem)this.getItem(index);
        if (result == null) {
            result = ItemFactory.createFloatItem(this.session);
            result.setValue(0.0);
            this.setItem(index, result, true);
        }
        return result;
    }

    public FloatItem getDoubleItem(int index) {
        return this.getFloatItem(index);
    }

    public FloatItem getDoubleItemCreateIfNotExists(int index) {
        return this.getFloatItemCreateIfNotExists(index);
    }

    public IntegerItem getIntegerItem(int index) {
        return (IntegerItem)this.getItem(index);
    }

    public IntegerItem getIntegerItemCreateIfNotExists(int index) {
        IntegerItem result = (IntegerItem)this.getItem(index);
        if (result == null) {
            result = ItemFactory.createIntegerItem(this.session);
            result.setValue(0);
            this.setItem(index, result, true);
        }
        return result;
    }

    public IntegerItem getByteItem(int index) {
        return this.getIntegerItem(index);
    }

    public IntegerItem getByteItemCreateIfNotExists(int index) {
        return this.getIntegerItemCreateIfNotExists(index);
    }

    public IntegerItem getShortItem(int index) {
        return this.getIntegerItem(index);
    }

    public IntegerItem getShortItemCreateIfNotExists(int index) {
        return this.getIntegerItemCreateIfNotExists(index);
    }

    public IntegerItem getLongItem(int index) {
        return this.getIntegerItem(index);
    }

    public IntegerItem getLongItemCreateIfNotExists(int index) {
        return this.getIntegerItemCreateIfNotExists(index);
    }

    public StringItem getStringItem(int index) {
        return (StringItem)this.getItem(index);
    }

    public StringItem getStringItemCreateIfNotExists(int index) {
        StringItem result = (StringItem)this.getItem(index);
        if (result == null) {
            result = ItemFactory.createStringItem(this.session);
            this.setItem(index, result, true);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName());
        result.append("[");
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            Item item = this.getItem(i);
            if (item == null) {
                result.append("[null]");
            } else {
                result.append(item.getClass().getName()).append("[").append(item.toString()).append("]");
            }
            if (i + 1 >= length) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    public Session getSession() {
        return this.session;
    }
}

