/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.xsltinterface;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.value.SequenceExtent;

public class XSLTInput
extends ch.e2e.builder.base.xsltinterface.XSLTInput {
    private static Map<String, String> parameterMap = new HashMap<String, String>();

    public static String getVariable(String name) {
        return parameterMap.get(name);
    }

    public static void setParameter(Map<String, String> parameterMap) {
        XSLTInput.parameterMap = parameterMap;
    }

    public static GroundedValue wrap(XPathContext context, String text, int x, int y, int lineHeight, int maxWidth) {
        try {
            TinyBuilder builder = XSLTInput.createBuilder((XPathContext)context);
            int lineNr = 0;
            builder.startDocument(0);
            XSLTInput.startElement((XPathContext)context, (TinyBuilder)builder, (String)"wrapper");
            XSLTInput.buildPlaintext(context, builder, x, y, lineHeight, maxWidth, lineNr, text);
            builder.endElement();
            builder.endDocument();
            NodeInfo doc = builder.getCurrentRoot();
            return new SequenceExtent((SequenceIterator)doc.iterateAxis(Axis.CHILD.getAxisNumber(), (NodeTest)AnyNodeTest.getInstance()));
        }
        catch (TransformerException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private static int buildPlaintext(XPathContext context, TinyBuilder builder, int x, int y, int lineHeight, int maxWidth, int lineNr, String text) throws XPathException {
        String[] wrapped = XSLTInput.wrapText(text, maxWidth);
        if (wrapped.length > 1) {
            for (String aWrapped : wrapped) {
                XSLTInput.appendSimpleTextElement(context, builder, aWrapped, x, y + lineNr * lineHeight);
                ++lineNr;
            }
        } else {
            XSLTInput.appendSimpleTextElement(context, builder, text, x, y + lineNr * lineHeight);
            ++lineNr;
        }
        return lineNr;
    }

    private static String[] wrapText(String s, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        Pattern wrapRE = Pattern.compile("(\\S\\S{" + maxWidth + ",}|.{1," + maxWidth + "})(\\s+|$)");
        Matcher matcher = wrapRE.matcher(s);
        while (matcher.find()) {
            String line = matcher.group();
            if (line.charAt(line.length() - 1) == ' ') {
                line = line.substring(0, line.length() - 1);
            }
            lines.add(line);
        }
        String[] result = new String[lines.size()];
        lines.toArray(result);
        return result;
    }

    private static void appendSimpleTextElement(XPathContext context, TinyBuilder builder, String text, int x, int y) throws XPathException {
        XSLTInput.startElement((XPathContext)context, (TinyBuilder)builder, (String)"text");
        XSLTInput.addAttribute((XPathContext)context, (TinyBuilder)builder, (String)"x", (String)String.valueOf(x));
        XSLTInput.addAttribute((XPathContext)context, (TinyBuilder)builder, (String)"y", (String)String.valueOf(y));
        XSLTInput.startElement((XPathContext)context, (TinyBuilder)builder, (String)"tspan");
        builder.characters((CharSequence)text, (Location)ExplicitLocation.UNKNOWN_LOCATION, text.length());
        builder.endElement();
        builder.endElement();
    }
}

