/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.logging.LogManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public abstract class UmlObjectVisitor {
    public static final Logger LOGGER = LogManager.getLogger((String)"ch.e2e.builder.trace.testcase.uml");
    private static final String METHOD_NAME = "visit";

    public void visit(UmlObject object) {
        this.visit((Object)object);
    }

    public void visitChilds(UmlObject parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.visit(parent.getChild(i));
        }
    }

    public void visitChilds(UmlObject parent, Class<?> type) {
        if (type == null) {
            this.visitChilds(parent);
        } else {
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                Object child = parent.getChild(i);
                if (!type.isInstance(child)) continue;
                this.visit(child);
            }
        }
    }

    private void visit(Object object) {
        Method m = this.getMethod(object.getClass());
        if (m != null) {
            try {
                m.invoke((Object)this, object);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private Method getMethod(Class visited) {
        Class clazz = visited;
        Method m = null;
        while (m == null && clazz != UmlObject.class) {
            try {
                m = this.getClass().getMethod(METHOD_NAME, clazz);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return m;
    }
}

