/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.ActionScriptTransformer;
import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.Logging;
import ch.e2e.builder.trace.testcase.uml.Pin;
import ch.e2e.builder.trace.tools.ActionScriptHelper;
import ch.e2e.dom.DomUtilities;
import ch.e2e.transformer.TransformerLoadException;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InputPin
extends Pin {
    private File ioFile;
    private String displayName = null;
    private static final Matcher MATCHER = Pattern.compile("<a href=\"[^>]*>|</a>|\n").matcher("");

    public InputPin(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        this.ioFile = traceContainer.getTestcase().getIOFile();
    }

    public InputPin(Element element, File documentFolder) {
        super(element, documentFolder);
        this.ioFile = new File(documentFolder, ".io");
    }

    @Override
    public Data getData() {
        Data data = super.getData();
        return this.getTransformation() == null ? data : new Data(this.toString(), data.getValue(), data.getDatatype(), true);
    }

    @Override
    public int internalGetType() {
        return 10042;
    }

    @Override
    public String toString() {
        if (this.displayName == null) {
            if (this.transformation == null) {
                this.displayName = this.externalName + " -> " + this.name;
            } else if (this.transformation.contains("---")) {
                this.displayName = "transformation -> " + this.name;
            } else {
                String s = new ActionScriptHelper(this.ioFile).resolveActionScriptIO(this.transformation);
                this.displayName = MATCHER.reset(s).replaceAll("") + " -> " + this.name;
            }
        }
        return this.displayName;
    }

    @Override
    protected void setNames(Element element) {
        try {
            Node result = (Node)DomUtilities.evaluate((Node)element, (String)"output[1]/*[1]", (NamespaceContext)null, (QName)XPathConstants.NODE);
            if (result != null) {
                String[] names = result.getNodeName().split("[.]+");
                Node function = (Node)DomUtilities.evaluate((Node)element, (String)"function[1]", (NamespaceContext)null, (QName)XPathConstants.NODE);
                this.name = names[0];
                if (function == null) {
                    if (names.length == 2) {
                        this.externalName = names[1];
                    } else if (names.length > 2) {
                        this.transformation = Stream.of(names).skip(1L).collect(Collectors.joining("."));
                    }
                } else {
                    Document doc = DomUtilities.newDocument((String)"SCRIPT");
                    doc.getDocumentElement().appendChild(doc.importNode(function, true));
                    this.transformation = new ActionScriptTransformer().transform(new DOMSource(doc));
                }
            }
        }
        catch (TransformerLoadException | IOException | TransformerException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "setNames", e);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }
}

