/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.parameter.NativeTypeParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import org.w3c.dom.Element;

public class BooleanParameter
extends NativeTypeParameter {
    public BooleanParameter(Element parameterElement, boolean arrayItem, int type, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this(parameterElement, type, arrayItem, parent, definitionHolder, false);
    }

    public BooleanParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        super(parameterElement, type, arrayItem, parent, definitionHolder, namespaceAware);
    }

    private BooleanParameter(String name, boolean arrayItem, int type, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        super(name, type, arrayItem, parent, definitionHolder);
        this.setValue(Boolean.FALSE);
    }

    @Override
    public BooleanParameter copy(RecordParameter parent) {
        BooleanParameter result = new BooleanParameter(this.getName(), this.isArrayItem(), this.getType(), parent, this.getDefinitionHolder());
        result.setValue(this.getValue());
        return result;
    }

    @Override
    public String getDiagramName() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Base Types.Boolean";
    }

    @Override
    public boolean importValue(Object value) {
        boolean imported;
        if (value == null) {
            this.setValue(value);
            imported = true;
        } else {
            this.setValue(Boolean.parseBoolean(value.toString()));
            imported = true;
        }
        return imported;
    }

    @Override
    Object createValue(Element parameterElement) {
        Boolean result = parameterElement.hasChildNodes() ? Boolean.valueOf(parameterElement.getFirstChild().getNodeValue()) : Boolean.FALSE;
        return result;
    }

    @Override
    public Parameter createEmptyParameter(RecordParameter parent) {
        return new BooleanParameter(this.getName(), this.isArrayItem(), this.getType(), parent, this.getDefinitionHolder());
    }
}

