/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.request;

import ch.e2e.builder.base.tools.ClientFactory;
import ch.e2e.builder.trace.request.RequestException;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.Credentials;

public class BearerTokenCredentials
implements Credentials {
    public static final String KEYCLOAK_TOKEN_ENDPOINT = "/keycloak/realms/PAS/protocol/openid-connect/token";
    public static final WebTarget KEYCLOAK_ACCESS_TOKEN_WEB_TARGET = ClientFactory.createSimpleTrustingClient().target("{BASE_URI}/keycloak/realms/PAS/protocol/openid-connect/token");
    public static final String SCHEME = "Bearer";
    private final String location;
    private final String username;
    private final String password;

    public BearerTokenCredentials(String location, String username, String password) {
        this.location = location;
        this.username = username;
        this.password = password;
    }

    public String requestAuthorizationValue() throws RequestException {
        return String.format("%s %s", SCHEME, this.requestAccessToken());
    }

    public String requestAccessToken() throws RequestException {
        WebTarget target = KEYCLOAK_ACCESS_TOKEN_WEB_TARGET.resolveTemplateFromEncoded("BASE_URI", (Object)this.getBaseUrl());
        try (Response response = target.request(new String[]{"application/json"}).post(Entity.form((Form)new Form().param("client_id", "admin-cli").param("grant_type", "password").param("username", this.username).param("password", this.password)));){
            JsonNode result = (JsonNode)response.readEntity(JsonNode.class);
            if (result.has("error")) {
                throw new RequestException(target.getUri().toString(), "HTTP_04", result.get("error_description").textValue());
            }
            String string = result.get("access_token").textValue();
            return string;
        }
    }

    String getBaseUrl() throws RequestException {
        try {
            URI uri = new URI(this.location);
            int totalLength = this.location.length();
            int pathLength = uri.getPath().length();
            int pos = this.location.indexOf("/", totalLength - pathLength + 1);
            if (pos == -1) {
                throw new RequestException(this.location, "HTTP_04", "Invalid URI.");
            }
            return this.location.substring(0, pos);
        }
        catch (URISyntaxException e) {
            throw new RequestException(this.location, "HTTP_04", "Invalid URI.");
        }
    }
}

