/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.ModuleDescriptionDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.plugin.module.ModuleFramePlugin;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.swing.MultiLineLabel;
import ch.e2e.util.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class NoModuleLicensePanel
extends JPanel {
    private ModuleDescriptionDialog descriptionDialog;

    public NoModuleLicensePanel(E2EBuilderModule module) {
        super(new BorderLayout());
        String message = module.getTranslation(module.getName() + ".no.license.message");
        if (message == null) {
            message = E2EBuilderTranslator.getTranslation((String)"default.no.module.license.message");
            message = StringTools.replaceProperty((String)message, (String)"module.title", (String)module.getTitle());
        }
        this.createGui(message, module);
    }

    private void createGui(String message, final E2EBuilderModule module) {
        boolean createLink;
        MultiLineLabel messageLabel = new MultiLineLabel(message);
        this.add((Component)messageLabel, "Center");
        boolean bl = createLink = module.getPlugin() != null && !(module.getPlugin() instanceof ModuleFramePlugin);
        if (createLink) {
            JButton description = ComponentFactory.createButton("module.description.button");
            description.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NoModuleLicensePanel.this.showDescription(module);
                }
            });
            JPanel south = new JPanel(new FlowLayout());
            south.add(description);
            this.add((Component)south, "South");
        }
    }

    private void showDescription(E2EBuilderModule module) {
        if (this.descriptionDialog == null) {
            this.descriptionDialog = new ModuleDescriptionDialog(module);
        }
        this.descriptionDialog.showDialog();
    }
}

