/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.application;

import ch.e2e.builder.base.application.abstracts.MenuObserver;
import ch.e2e.builder.base.gui.menu.E2EBuilderMenuBar;
import ch.e2e.builder.base.gui.menu.PredefinedMenuItems;
import ch.e2e.builder.base.gui.toolbar.E2EBuilderToolBar;
import ch.e2e.builder.base.licensing.LicenseValidator;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.swing.event.MenuEventObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.Icon;

public class E2EBuilderMenuObserver
extends MenuObserver {
    private E2EBuilderMenuBar menuBar;
    private E2EBuilderToolBar toolBar;
    private ArrayList<Object> defaultItems;
    private ArrayList<Object> addedMenuElements = new ArrayList();
    private ArrayList<MenuObserver.RegisteredMenuExecuter> registerMenuExecuter = new ArrayList();
    private ArrayList<MenuObserver.ToggledItem> selectedItems = new ArrayList();
    private ArrayList<MenuObserver.ToggledItem> enabledItems = new ArrayList();

    public void setMenuBar(E2EBuilderMenuBar menuBar) {
        this.menuBar = menuBar;
        Field[] predefinedItems = PredefinedMenuItems.class.getFields();
        this.defaultItems = new ArrayList(predefinedItems.length);
        for (Field predefinedItem : predefinedItems) {
            try {
                this.defaultItems.add(predefinedItem.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initialize();
    }

    public void setToolBar(E2EBuilderToolBar toolBar) {
        this.toolBar = toolBar;
    }

    @Override
    public void setMenuEnabled(E2EBuilderModule module, String menuName, boolean enabled) {
        if (this.menuBar != null) {
            this.menuBar.setMenuEnabled(menuName, enabled);
        }
    }

    @Override
    protected void setItemEnabled(E2EBuilderModule module, String[] itemNames, boolean enabled) {
        if (this.menuBar == null) {
            this.enabledItems.add(new MenuObserver.ToggledItem(itemNames, enabled));
        } else {
            this.menuBar.setItemEnabled(itemNames, enabled);
            if (this.toolBar != null) {
                this.toolBar.setItemEnabled(itemNames, enabled);
            }
        }
    }

    @Override
    protected void setItemSelected(E2EBuilderModule module, String[] itemNames, boolean selected) {
        if (this.menuBar == null) {
            this.selectedItems.add(new MenuObserver.ToggledItem(itemNames, selected));
        } else {
            this.menuBar.setItemSelected(itemNames, selected);
            if (this.toolBar != null) {
                this.toolBar.setItemSelected(itemNames, selected);
            }
        }
    }

    @Override
    public void doOnShow(E2EBuilderModule module) {
        super.doOnShow(module);
        this.menuBar.setVisible(module.getName(), true);
    }

    @Override
    public void doOnRelease(E2EBuilderModule module) {
        super.doOnRelease(module);
        this.menuBar.setVisible(module.getName(), false);
    }

    @Override
    protected void addMenuItem(E2EBuilderModule module, String[] itemNames, Icon icon, MenuEventObject event, int index) {
        this.addedMenuElements.add(new MenuObserver.MenuElement(module.getName(), itemNames, icon, event, index));
    }

    @Override
    protected void registerMenuEvent(E2EBuilderModule module, String menuKey, EventExecuter executer) {
        this.registerMenuExecuter.add(new MenuObserver.RegisteredMenuExecuter(module.getName(), menuKey, executer));
    }

    @Override
    protected void addMenuSeparator(E2EBuilderModule module, String[] menuNames) {
        this.addedMenuElements.add(new MenuObserver.Separator(module.getName(), menuNames));
    }

    @Override
    protected void checkLicense(LicenseValidator license) {
        if (this.menuBar != null) {
            this.menuBar.setBuilderExpired(license.isExpired());
        }
    }

    private void initialize() {
        this.addMenuElements();
        this.setRegisteredExecuter();
        this.setItemsSelected();
        this.setItemsEnabled();
    }

    private void addMenuElements() {
        int length = this.addedMenuElements.size();
        for (Object element : this.addedMenuElements) {
            if (element instanceof MenuObserver.MenuElement) {
                MenuObserver.MenuElement item = (MenuObserver.MenuElement)element;
                this.menuBar.createMenuItem(item.moduleName, item.itemNames, item.icon, item.event, item.index);
                continue;
            }
            if (!(element instanceof MenuObserver.Separator)) continue;
            MenuObserver.Separator separator = (MenuObserver.Separator)element;
            this.menuBar.addSeparator(separator.moduleName, separator.menuNames);
        }
        this.addedMenuElements.clear();
        this.addedMenuElements = null;
    }

    private void setRegisteredExecuter() {
        int length = this.registerMenuExecuter.size();
        for (int i = 0; i < length; ++i) {
            MenuObserver.RegisteredMenuExecuter executer = this.registerMenuExecuter.get(i);
            if (this.defaultItems.contains(executer.menuKey)) {
                ArrayList<MenuObserver.MenuExecuter> defaultItemExecuters = (ArrayList<MenuObserver.MenuExecuter>)this.executerLists.get(executer.moduleName);
                if (defaultItemExecuters == null) {
                    defaultItemExecuters = new ArrayList<MenuObserver.MenuExecuter>();
                    this.executerLists.put(executer.moduleName, defaultItemExecuters);
                }
                defaultItemExecuters.add(new MenuObserver.MenuExecuter(this.menuBar.getMenuEvent(executer.menuKey), executer.executer));
                continue;
            }
            MenuEventObject event = this.menuBar.getMenuEvent(executer.menuKey);
            if (event == null) continue;
            EventController.register((EventExecuter)executer.executer, event.getClass());
        }
        this.registerMenuExecuter.clear();
        this.registerMenuExecuter = null;
    }

    private void setItemsEnabled() {
        int length = this.enabledItems.size();
        for (int i = 0; i < length; ++i) {
            MenuObserver.ToggledItem item = this.enabledItems.get(i);
            this.menuBar.setItemEnabled(item.itemNames, item.state);
        }
        this.enabledItems.clear();
        this.enabledItems = null;
    }

    private void setItemsSelected() {
        int length = this.selectedItems.size();
        for (int i = 0; i < length; ++i) {
            MenuObserver.ToggledItem item = this.selectedItems.get(i);
            this.menuBar.setItemSelected(item.itemNames, item.state);
        }
        this.selectedItems.clear();
        this.selectedItems = null;
    }
}

