/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.importer;

import ch.e2e.builder.traceviewer.importer.Logging;
import ch.e2e.dom.DomUtilities;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.xpath.XPathEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AsynchronousImporter
implements Logging {
    private static final String PROTOCOL = "http://";
    private static final String PORT_SEPARATOR = ":";
    private static XPathExpression persistentStateClass;
    private static XPathExpression name;
    private static XPathExpression namespace;
    private static XPathExpression type;
    private static XPathExpression primaryKeys;
    private static XPathExpression serviceClassOperation;
    private static XPathExpression stereotype;
    private static AsynchronousImporter importer;

    private AsynchronousImporter() {
    }

    public static AsynchronousImporter getInstance() {
        if (importer == null) {
            importer = new AsynchronousImporter();
        }
        return importer;
    }

    public Document createTestcases(Document document) {
        Element element = document.getDocumentElement();
        Document template = DomUtilities.newDocument((String)"Testcases");
        try {
            this.transformStates(element, template);
            this.transformOperations(element, template);
        }
        catch (XPathExpressionException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "", e);
        }
        return template;
    }

    private void transformStates(Element element, Document template) throws XPathExpressionException {
        String hostname = element.getAttribute("host");
        String controlPort = element.getAttribute("controlPort");
        NodeList nodes = (NodeList)persistentStateClass.evaluate(element, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node keysNode;
            Element testcaseElement = template.createElement("Testcase");
            Element stateElement = template.createElement("PersistentStateClass");
            Node stateNode = nodes.item(i);
            Node node = (Node)name.evaluate(stateNode, XPathConstants.NODE);
            stateElement.setAttribute("name", node == null ? "unkown" : node.getNodeValue());
            node = (Node)namespace.evaluate(stateNode, XPathConstants.NODE);
            if (node != null) {
                stateElement.setAttribute("namespace", node.getNodeValue());
            }
            if ((node = (Node)type.evaluate(stateNode, XPathConstants.NODE)) != null) {
                stateElement.setAttribute("type", node.getNodeValue());
            }
            if ((keysNode = (Node)primaryKeys.evaluate(stateNode, XPathConstants.NODE)) != null) {
                stateElement.appendChild(template.importNode(keysNode, true));
            }
            testcaseElement.setAttribute("persistentState", "true");
            testcaseElement.setAttribute("location", PROTOCOL + hostname + PORT_SEPARATOR + controlPort);
            testcaseElement.appendChild(stateElement);
            template.getDocumentElement().appendChild(testcaseElement);
        }
    }

    private void transformOperations(Element element, Document template) throws XPathExpressionException {
        String hostname = element.getAttribute("host");
        String controlPort = element.getAttribute("controlPort");
        NodeList operations = (NodeList)serviceClassOperation.evaluate(element, XPathConstants.NODESET);
        for (int i = 0; i < operations.getLength(); ++i) {
            Node operationNode = operations.item(i);
            Node classNode = operationNode.getParentNode();
            Node serviceNode = classNode.getParentNode();
            Element testcaseElement = template.createElement("Testcase");
            Element serviceElement = this.transformService(serviceNode, template);
            Element classElement = this.transformClass(classNode, template);
            Element operationElement = this.transformOperation(operationNode, template);
            testcaseElement.setAttribute("location", PROTOCOL + hostname + PORT_SEPARATOR + controlPort);
            classElement.appendChild(operationElement);
            serviceElement.appendChild(classElement);
            testcaseElement.appendChild(serviceElement);
            template.getDocumentElement().appendChild(testcaseElement);
        }
    }

    private Element transformOperation(Node operationNode, Document template) throws XPathExpressionException {
        Element operationElement = template.createElement("Operation");
        Node node = (Node)name.evaluate(operationNode, XPathConstants.NODE);
        operationElement.setAttribute("name", node == null ? "unkown" : node.getNodeValue());
        node = (Node)namespace.evaluate(operationNode, XPathConstants.NODE);
        if (node != null) {
            operationElement.setAttribute("namespace", node.getNodeValue());
        }
        if ((node = (Node)type.evaluate(operationNode, XPathConstants.NODE)) != null) {
            operationElement.setAttribute("type", node.getNodeValue());
        }
        return operationElement;
    }

    private Element transformClass(Node classNode, Document template) throws XPathExpressionException {
        Element classElement = template.createElement("Class");
        Node node = (Node)name.evaluate(classNode, XPathConstants.NODE);
        classElement.setAttribute("name", node == null ? "unkown" : node.getNodeValue());
        node = (Node)stereotype.evaluate(classNode, XPathConstants.NODE);
        if (node != null) {
            classElement.setAttribute("stereotype", node.getNodeValue());
        }
        return classElement;
    }

    private Element transformService(Node serviceNode, Document template) throws XPathExpressionException {
        Element serviceElement = template.createElement("Service");
        Node node = (Node)name.evaluate(serviceNode, XPathConstants.NODE);
        serviceElement.setAttribute("name", node == null ? "unkown" : node.getNodeValue());
        node = (Node)stereotype.evaluate(serviceNode, XPathConstants.NODE);
        if (node != null) {
            serviceElement.setAttribute("stereotype", node.getNodeValue());
        }
        return serviceElement;
    }

    static {
        try {
            XPathEvaluator xpath = new XPathEvaluator();
            persistentStateClass = xpath.compile("PersistentStateClass");
            name = xpath.compile("Name/text()");
            namespace = xpath.compile("Namespace/text()");
            type = xpath.compile("Type/text()");
            primaryKeys = xpath.compile("PrimaryKeys");
            serviceClassOperation = xpath.compile("Service/Class/Operation");
            stereotype = xpath.compile("Stereotype/text()");
        }
        catch (XPathException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(AsynchronousImporter.class.getName(), "", e);
        }
    }
}

