/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.soap;

import ch.e2e.builder.traceviewer.execute.soap.Header;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

class RequestHeader
extends Header {
    private URL url;

    RequestHeader(InputStream in) throws MalformedURLException {
        super(in);
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    String getFirstLine(String line) throws MalformedURLException {
        String[] values = line.split(" ");
        this.url = new URL(values[1]);
        String protocol = values.length == 3 ? values[2].trim() : null;
        return this.createRequest(this.url, values[0], protocol);
    }

    private String createRequest(URL url, String method, String protocol) {
        StringBuilder request = new StringBuilder(method);
        request.append(" ").append(url.getPath());
        if (url.getQuery() != null && !url.getQuery().isEmpty()) {
            request.append("?").append(url.getQuery());
        }
        if (protocol != null && !protocol.isEmpty()) {
            request.append(" ").append(protocol);
        }
        request.append(CRLF);
        return request.toString();
    }
}

