/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.rest;

import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.trace.request.RequestException;
import ch.e2e.builder.traceviewer.execute.rest.AsyncRequest;
import ch.e2e.builder.traceviewer.execute.rest.RequestExecutor;
import ch.e2e.event.EventController;
import ch.e2e.util.StringTools;
import java.net.SocketException;
import java.util.EventObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AsyncRequestClient {
    public <R> R performRequest(AsyncRequest<R> request) throws RequestException {
        return this.performRequest(request, new RequestExecutor(request.getRequestLog(), request.getResponseLog()));
    }

    protected <R> R performRequest(AsyncRequest<R> request, RequestExecutor executor) throws RequestException {
        try {
            R response = executor.execute(request);
            this.checkStatus(request, response);
            return response;
        }
        catch (RequestException e) {
            EventController.fire((EventObject)new SendErrorEvent(request, this.createErrorMessage((Exception)((Object)e), request.getUri().toString())));
            throw e;
        }
    }

    private void checkStatus(AsyncRequest<?> request, Object response) {
        if (response instanceof Document) {
            this.checkStatus(request, (Document)response);
        }
    }

    private void checkStatus(AsyncRequest<?> request, Document response) {
        String error;
        Node errorNode;
        Node status = response.getElementsByTagName("Status").item(0);
        if (status != null && !status.getTextContent().equals("OK") && (errorNode = response.getElementsByTagName("Error").item(0)) != null && (error = errorNode.getTextContent()) != null) {
            EventController.fire((EventObject)new SendErrorEvent(request, String.format("HttpClient [%s]: %s", request.getUri().toString(), error)));
        }
    }

    private String createErrorMessage(Exception e, String location) {
        String result = e instanceof SocketException ? "http.client.error.connecting" : "http.client.error.exception";
        result = StringTools.replaceProperty((String)result, (String)"url", (String)location);
        String message = e.getMessage() == null ? "" : e.getMessage();
        result = StringTools.replaceProperty((String)result, (String)"exception.message", (String)(e instanceof NullPointerException ? "NullPointerException" : message));
        return result;
    }
}

