/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.gui.TestSuiteTreeCellRenderer;
import ch.e2e.builder.regtest.testsuite.TraceTestcase;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.resource.Properties;
import ch.e2e.swing.InputCheckBox;
import ch.e2e.swing.TreeObject;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.test.OptionContainer;
import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.tree.TreeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TestcaseReplaceSelectionDialog
extends E2EBuilderDialog {
    private static TestcaseReplaceSelectionDialog dialog;
    private TreeModel treeModel;
    private CheckBoxTree tree;
    private InputCheckBox overrideReferenceData;
    private E2EBuilderModule module;

    public TestcaseReplaceSelectionDialog(E2EBuilderModule module) {
        super(module.getTranslation("override.testcase.title"), module.getTranslation("override.testcase.internaltitle"), module.getTranslation("override.testcase.subtitle"), 3);
        this.module = module;
        this.createGui();
    }

    public static TestcaseReplaceSelectionDialog getInstance(E2EBuilderModule module) {
        if (dialog == null) {
            dialog = new TestcaseReplaceSelectionDialog(module);
        }
        return dialog;
    }

    public List<TraceTestcase> selectTestcasesToOverride(List<TraceTestcase> testcases) {
        SelectedTestcases root = new SelectedTestcases(testcases);
        return this.selectTestcasesToOverride(root);
    }

    public List<TraceTestcase> selectTestcasesToOverride(NameConflicRoot root) {
        List result = null;
        if (!root.isLeaf()) {
            this.treeModel.setRoot(root);
            this.treeModel.refresh();
            this.tree.getCheckBoxTreeSelectionModel().setSelectionPath(new TreePath(this.tree.getModel().getRoot()));
            TreeUtils.expandAll((JTree)this.tree);
            this.overrideReferenceData.setSelected(true);
            if (this.showDialog() == 1) {
                TreePath[] selection = this.tree.getCheckBoxTreeSelectionModel().getSelectionPaths();
                if (selection.length == 0) {
                    result = Collections.emptyList();
                } else {
                    result = new ArrayList();
                    for (TreePath treePath : selection) {
                        if (!(treePath.getLastPathComponent() instanceof OverrideTreeObject)) continue;
                        result.addAll(((OverrideTreeObject)treePath.getLastPathComponent()).getAllTestcases());
                    }
                }
            }
        }
        return result;
    }

    public boolean isOverrideRefernecData() {
        return this.overrideReferenceData.isSelected();
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        this.treeModel = new TreeModel();
        this.tree = new CheckBoxTree((javax.swing.tree.TreeModel)((Object)this.treeModel));
        TestSuiteTreeCellRenderer renderer = new TestSuiteTreeCellRenderer(this.treeModel);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)renderer));
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.getCheckBoxTreeSelectionModel().setSelectionMode(4);
        JScrollPane scrollPane = new JScrollPane((Component)this.tree, 20, 30);
        this.add(scrollPane, "Center");
        this.overrideReferenceData = ComponentFactory.createCheckBox((String)"override.testcase.checkbox.override.reference.data", (E2EBuilderModule)this.module);
        this.add((Component)this.overrideReferenceData, "South");
    }

    public static class NameConflicRoot
    extends OverrideTreeObject {
        public NameConflicRoot(TestcaseContainer original) {
            super(original);
        }

        public void addNameConflict(TestcaseContainer nameConflict) {
            ArrayList<TestcaseContainer> pathElements = new ArrayList<TestcaseContainer>();
            pathElements.add(nameConflict);
            TestcaseContainer parent = nameConflict.getParent();
            while (!parent.equals((Object)this.getOriginal())) {
                pathElements.add(0, parent);
                parent = parent.getParent();
            }
            OverrideTreeObject treeObject = this;
            for (TestcaseContainer container : pathElements) {
                treeObject = treeObject.addChild(container);
            }
        }
    }

    public static class OverrideTreeObject
    implements TreeObject {
        private TestcaseContainer original;
        private Map<TestcaseContainer, OverrideTreeObject> children = new HashMap<TestcaseContainer, OverrideTreeObject>();
        private List<OverrideTreeObject> childList = new ArrayList<OverrideTreeObject>();

        public OverrideTreeObject(TestcaseContainer original) {
            this.original = original;
        }

        public OverrideTreeObject addChild(TestcaseContainer child) {
            OverrideTreeObject result = this.children.get(child);
            if (result == null) {
                result = new OverrideTreeObject(child);
                this.children.put(child, result);
                this.childList.add(result);
            }
            return result;
        }

        public Object getChild(int index) {
            return this.childList.get(index);
        }

        public int getChildCount() {
            return this.childList.size();
        }

        public int getIndexOfChild(Object child) {
            return this.childList.indexOf(child);
        }

        public boolean isLeaf() {
            return this.childList.size() == 0;
        }

        public int getType() {
            return this.original.getType();
        }

        public TreeObject getOriginal() {
            return this.original;
        }

        public String toString() {
            return this.original.toString();
        }

        public List<TraceTestcase> getAllTestcases() {
            ArrayList<TraceTestcase> result = new ArrayList<TraceTestcase>();
            if (this.original instanceof TraceTestcase) {
                result.add((TraceTestcase)this.original);
            } else {
                for (TestcaseContainer container : this.children.keySet()) {
                    if (container instanceof TraceTestcase) {
                        result.add((TraceTestcase)container);
                        continue;
                    }
                    result.addAll(this.children.get(container).getAllTestcases());
                }
            }
            return result;
        }
    }

    private class TreeModel
    extends AbstractTreeModel {
        private NameConflicRoot root;

        private TreeModel() {
            super(new Properties("ch.e2e.builder.regtest.properties.importSelectionTree"));
        }

        public Object getRoot() {
            return this.root;
        }

        public void setRoot(NameConflicRoot root) {
            this.root = root;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public String getTypeString(int type) {
            String result;
            switch (type) {
                case 1007: {
                    result = "treenode.testcase.selectable.unknown";
                    break;
                }
                case 1006: {
                    result = "treenode.testcase.selectable.ok";
                    break;
                }
                case 1008: {
                    result = "treenode.testcase.selectable.error";
                    break;
                }
                case 1150: {
                    result = "treenode.testcase.name.conflict";
                    break;
                }
                case 1001: {
                    result = "treenode.testcase.not.selectable";
                    break;
                }
                case 5000: {
                    result = "treenode.testcase.root.selectable";
                    break;
                }
                case 5150: {
                    result = "treenode.testcase.root.name.conflict";
                    break;
                }
                case 5001: {
                    result = "treenode.testcase.root.not.selectable";
                    break;
                }
                case 2000: {
                    result = "treenode.wsdl.selectable";
                    break;
                }
                case 2150: {
                    result = "treenode.wsdl.name.conflict";
                    break;
                }
                case 2001: {
                    result = "treenode.wsdl.not.selectable";
                    break;
                }
                case 4000: {
                    result = "treenode.operation.selectable";
                    break;
                }
                case 4150: {
                    result = "treenode.operation.name.conflict";
                    break;
                }
                case 4001: {
                    result = "treenode.operation.not.selectable";
                    break;
                }
                case 3003: {
                    result = "treenode.service.selectable";
                    break;
                }
                case 3153: {
                    result = "treenode.service.name.conflict";
                    break;
                }
                case 3503: {
                    result = "treenode.service.not.selectable";
                    break;
                }
                case 3004: {
                    result = "treenode.port.selectable";
                    break;
                }
                case 3154: {
                    result = "treenode.port.name.conflict";
                    break;
                }
                case 3504: {
                    result = "treenode.port.not.selectable";
                    break;
                }
                default: {
                    result = "treenode.unknown";
                }
            }
            return result;
        }

        public int getType(Object value) {
            int result = value instanceof OptionContainer ? 600 : super.getType(value);
            return result;
        }

        public String toString(Object value) {
            String result = value instanceof OptionContainer ? ((OptionContainer)value).getOwner().toString() : super.toString(value);
            return result;
        }
    }

    private class SelectedTestcases
    extends NameConflicRoot {
        private SelectedTestcases(Collection<TraceTestcase> testcases) {
            super(null);
            for (TraceTestcase testcase : testcases) {
                this.addChild((TestcaseContainer)testcase);
            }
        }

        @Override
        public int getType() {
            return 600;
        }

        @Override
        public String toString() {
            return TestcaseReplaceSelectionDialog.this.module.getTranslation("override.testcase.tree.title", "override.testcase.tree.title");
        }
    }
}

