/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.response;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MockInfo {
    private final String fullInfo;
    private final String summary;
    private final int numberOfMockups;
    private final int numberOfMockupsUsed;
    private final Error[] errors;

    public MockInfo(Element mockElement) {
        StringBuilder infoBuilder = new StringBuilder();
        Element summaryElement = (Element)mockElement.getElementsByTagNameNS("http://e2e.ch/bridge", "Summary").item(0);
        this.summary = summaryElement.getTextContent();
        infoBuilder.append(this.summary).append("\n");
        this.numberOfMockups = Integer.parseInt(summaryElement.getAttribute("mockups"));
        this.numberOfMockupsUsed = Integer.parseInt(summaryElement.getAttribute("mockupsUsed"));
        NodeList errorNodes = mockElement.getElementsByTagNameNS("http://e2e.ch/bridge", "Error");
        int nErrors = errorNodes.getLength();
        this.errors = new Error[nErrors];
        for (int i = 0; i < nErrors; ++i) {
            this.errors[i] = new Error((Element)errorNodes.item(i));
            infoBuilder.append(this.errors[i].getError()).append("\n");
        }
        this.fullInfo = infoBuilder.toString();
    }

    public String getSummary() {
        return this.summary;
    }

    public Error[] getErrors() {
        return this.errors;
    }

    public boolean containsErrors() {
        return this.errors.length > 0;
    }

    public int getNumberOfMockups() {
        return this.numberOfMockups;
    }

    public int getNumberOfMockupsUsed() {
        return this.numberOfMockupsUsed;
    }

    public static class Error {
        private final int code;
        private final String component;
        private final String error;

        public Error(Element element) {
            this.code = Integer.parseInt(element.getAttribute("code"));
            this.component = element.getAttribute("component");
            this.error = element.getTextContent();
        }

        public int getCode() {
            return this.code;
        }

        public String getComponent() {
            return this.component;
        }

        public String getError() {
            return this.error;
        }
    }
}

