/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AdapterOutputContainer;
import ch.e2e.builder.trace.testcase.AdapterTemplateInfo;
import ch.e2e.dom.DomUtilities;
import com.jidesoft.utils.SortedList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AdapterOutputContainerList
extends SortedList<AdapterOutputContainer> {
    private final boolean readOutputsFile;
    private AbstractSynchronousTestcase testcase;

    public AdapterOutputContainerList(AbstractSynchronousTestcase testcase, boolean readOutputsFile) {
        super(new ArrayList(), (Comparator)new ContainerComparator());
        this.readOutputsFile = readOutputsFile;
        this.setTestcase(testcase, readOutputsFile);
    }

    public AdapterOutputContainerList(AbstractSynchronousTestcase testcase) {
        this(testcase, true);
    }

    public boolean isReadOutputsFile() {
        return this.readOutputsFile;
    }

    private void setTestcase(AbstractSynchronousTestcase testcase, boolean readOutputsFile) {
        this.testcase = testcase;
        this.clear();
        File adapterInfos = new File(testcase.getAdapterInfoHome(), "adapter.template.ids");
        if (adapterInfos.exists()) {
            try {
                Document adapterInfosDocument = DomUtilities.parse((File)adapterInfos, (boolean)false, (boolean)false, (boolean)false);
                NodeList infoElements = adapterInfosDocument.getDocumentElement().getElementsByTagName("UniqueId");
                int length = infoElements.getLength();
                for (int i = 0; i < length; ++i) {
                    this.add(new AdapterOutputContainer(new AdapterTemplateInfo((Element)infoElements.item(i)), testcase, readOutputsFile));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void save() throws TransformerException, IOException {
        this.testcase.getAdapterOutputsFile().delete();
        if (!this.isEmpty()) {
            DomUtilities.serialize((File)this.testcase.getAdapterOutputsFile(), (Document)this.createAdapterOutputsDocument(), (boolean)true);
        }
    }

    public boolean isEmpty() {
        boolean result = super.isEmpty();
        if (!result) {
            result = true;
            int length = this.size();
            for (int i = 0; i < length && result; ++i) {
                result = ((AdapterOutputContainer)this.get(i)).isEmpty();
            }
        }
        return result;
    }

    private Document createAdapterOutputsDocument() {
        Document document = DomUtilities.newDocument((String)"AdapterOutputs");
        Element root = document.getDocumentElement();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            AdapterOutputContainer adapterOutputContainer = (AdapterOutputContainer)iterator.next();
            Element element = adapterOutputContainer.createAdapterOutputContainerElement(document);
            if (element == null) continue;
            root.appendChild(element);
        }
        return document;
    }

    private static class ContainerComparator
    implements Comparator<AdapterOutputContainer> {
        private ContainerComparator() {
        }

        @Override
        public int compare(AdapterOutputContainer o1, AdapterOutputContainer o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }
}

