/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import ch.e2e.builder.compiler.net.BridgeServiceAction;
import ch.e2e.builder.compiler.net.Login;
import ch.e2e.builder.compiler.net.LoginFailedException;
import ch.e2e.builder.compiler.net.ServiceStopTest;
import ch.e2e.io.FileUtilities;
import ch.e2e.secure.HttpsUtil;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2ETest;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.Utilities;
import ch.e2e.test.XMLCompare;
import ch.e2e.test.options.CompareFileOption;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.IntegerOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.PasswordOption;
import ch.e2e.test.options.StringOption;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class ServiceTest
extends E2ETest {
    public static final String KEY_OPTION_LOGFILE = "service.test.logfile";
    public static final String KEY_OPTION_NODE = "service.test.node";
    public static final String KEY_OPTION_SERVICE = "service.test.service";
    public static final String KEY_OPTION_HOST = "service.test.host";
    public static final String KEY_OPTION_PORT = "service.test.port";
    public static final String KEY_OPTION_USERNAME = "service.test.username";
    public static final String KEY_OPTION_PASSWORD = "service.test.password";
    public static final String KEY_OPTION_SERVICE_TYPE = "service.test.type";

    public String getRecommendedCompareType() {
        return "XmlCompare";
    }

    public void setTestFolder(File testFolder) {
        super.setTestFolder(testFolder);
        FileOption logfile = (FileOption)this.getOptions().get(KEY_OPTION_LOGFILE);
        File defaultValue = new File(testFolder, "${service.test.service}/${service.test.node}." + this.getDefaultLogfileName());
        logfile.setDependencyString(defaultValue.getAbsolutePath());
        logfile.setDefaultValue((Object)defaultValue);
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                if (!(compare instanceof XMLCompare)) continue;
                CompareFileOption testFile = (CompareFileOption)compare.getOptions().get("xml.compare.test.file");
                testFile.setDependencyString("${service.test.logfile}");
                testFile.setDefaultValue((Object)new CompareFile(new File("${service.test.logfile}")));
            }
        }
    }

    public void setReferenceFolder(File referenceFolder) {
        super.setReferenceFolder(referenceFolder);
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                if (!(compare instanceof XMLCompare)) continue;
                CompareFileOption referenceFile = (CompareFileOption)compare.getOptions().get("xml.compare.reference.file");
                File defaultValue = new File(referenceFolder, "${service.test.service}/${service.test.node}." + this.getDefaultLogfileName());
                referenceFile.setDependencyString(defaultValue.getAbsolutePath());
                referenceFile.setDefaultValue((Object)new CompareFile(defaultValue));
            }
        }
    }

    public void setSourceFolder(File referenceFolder) {
    }

    public void prepareCompareType(ResultCompare compare) {
        if (compare instanceof XMLCompare) {
            CompareFileOption testFile = (CompareFileOption)compare.getOptions().get("xml.compare.test.file");
            testFile.addDependency(KEY_OPTION_LOGFILE);
            testFile.setDependencyString("${service.test.logfile}");
            testFile.setDefaultValue((Object)new CompareFile(new File("${service.test.logfile}")));
            CompareFileOption referenceFile = (CompareFileOption)compare.getOptions().get("xml.compare.reference.file");
            File defaultValue = new File(this.getReferenceFolder(), "${service.test.service}/${service.test.node}." + this.getDefaultLogfileName());
            referenceFile.addDependency(KEY_OPTION_NODE);
            referenceFile.addDependency(KEY_OPTION_SERVICE);
            referenceFile.setDependencyString(defaultValue.getAbsolutePath());
            referenceFile.setDefaultValue((Object)new CompareFile(defaultValue));
            StringOption nameOption = (StringOption)compare.getOptions().get("key.option.result.compare.name");
            String defaultName = "Compare ${service.test.service} " + this.getDefaultLogfileName();
            nameOption.addDependency(KEY_OPTION_SERVICE);
            nameOption.setDependencyString(defaultName);
            nameOption.setDefaultValue((Object)defaultName);
        }
    }

    public abstract String getTypeString();

    public abstract String getDefaultLogfileName();

    public void setName(StringOption nameOption) {
        nameOption.addDependency(KEY_OPTION_SERVICE);
        nameOption.setDependencyString(this.getTypeString() + " ${" + KEY_OPTION_SERVICE + "}");
        nameOption.setDefaultValue((Object)(this.getTypeString() + " ${" + KEY_OPTION_SERVICE + "}"));
        super.setName(nameOption);
    }

    private void doAction(BridgeServiceAction action) throws IOException, LoginFailedException {
        Object timeoutValue;
        Login login = this.getLogin();
        StringOption nodeNameOption = (StringOption)this.getOption(KEY_OPTION_NODE);
        String nodeName = nodeNameOption.getValue() == null ? (String)nodeNameOption.getDefaultValue() : (String)nodeNameOption.getValue();
        StringOption serviceOption = (StringOption)this.getOption(KEY_OPTION_SERVICE);
        String serviceName = serviceOption.getValue() == null ? (String)serviceOption.getDefaultValue() : (String)serviceOption.getValue();
        File logfile = (File)this.getOptionValue(KEY_OPTION_LOGFILE);
        logfile.delete();
        int timeout = -1;
        if (this instanceof ServiceStopTest && (timeoutValue = this.getOption("service.test.stop.timeout").getValue()) != null) {
            timeout = (Integer)timeoutValue;
        }
        String result = action.configureService(serviceName, nodeName.toLowerCase(), login, timeout);
        logfile.getParentFile().mkdirs();
        FileUtilities.copy((Reader)new StringReader(result), (Writer)new FileWriter(logfile));
    }

    private Login getLogin() {
        StringOption hostOption = (StringOption)this.getOption(KEY_OPTION_HOST);
        String host = hostOption.getValue() == null ? (String)hostOption.getDefaultValue() : (String)hostOption.getValue();
        IntegerOption portOption = (IntegerOption)this.getOption(KEY_OPTION_PORT);
        int port = portOption.getValue() == null ? ((Integer)portOption.getDefaultValue()).intValue() : ((Integer)portOption.getValue()).intValue();
        StringOption usernameOption = (StringOption)this.getOption(KEY_OPTION_USERNAME);
        String username = usernameOption.getValue() == null ? (String)usernameOption.getDefaultValue() : (String)usernameOption.getValue();
        PasswordOption passwordOption = (PasswordOption)this.getOption(KEY_OPTION_PASSWORD);
        String password = passwordOption.getValue() == null ? (String)passwordOption.getDefaultValue() : (String)passwordOption.getValue();
        return new Login(username, password, host, port);
    }

    protected void createOptions() {
        StringOption node;
        StringOption host = new StringOption("Host", KEY_OPTION_HOST, "localhost", 1);
        this.addOption(KEY_OPTION_HOST, (Option)host);
        host.setRequired(false);
        IntegerOption port = new IntegerOption("Port", KEY_OPTION_PORT, Integer.valueOf(8080), 2);
        port.setMaxValue(99999);
        port.setMinValue(1);
        port.setRequired(true);
        this.addOption(KEY_OPTION_PORT, (Option)port);
        try {
            node = new StringOption("Nodename", KEY_OPTION_NODE, InetAddress.getLocalHost().getCanonicalHostName(), 3);
        }
        catch (UnknownHostException e) {
            node = new StringOption("Nodename", KEY_OPTION_NODE, "localhost", 2);
        }
        node.setRequired(false);
        this.addOption(KEY_OPTION_NODE, (Option)node);
        StringOption service = new StringOption("E2E Service", KEY_OPTION_SERVICE, "undefined", -200);
        service.setRequired(true);
        this.addOption(KEY_OPTION_SERVICE, (Option)service);
        StringOption username = new StringOption("Username", KEY_OPTION_USERNAME, "", 4);
        username.setRequired(true);
        this.addOption(KEY_OPTION_USERNAME, (Option)username);
        PasswordOption password = new PasswordOption("Password", KEY_OPTION_PASSWORD, "", 5);
        password.setRequired(true);
        this.addOption(KEY_OPTION_PASSWORD, (Option)password);
        FileOption logfile = new FileOption("Logfile", KEY_OPTION_LOGFILE, new File("${service.test.service}/${service.test.node}." + this.getDefaultLogfileName()), 6);
        logfile.addDependency(KEY_OPTION_NODE);
        logfile.addDependency(KEY_OPTION_SERVICE);
        logfile.setDependencyString("${service.test.service}/${service.test.node}." + this.getDefaultLogfileName());
        logfile.setRequired(true);
        logfile.addFileExtension("log", "Logfile");
        this.addOption(KEY_OPTION_LOGFILE, (Option)logfile);
        this.addOption(KEY_OPTION_SERVICE_TYPE, (Option)new StringOption("Service Type", KEY_OPTION_SERVICE_TYPE, null, 0));
        if (this instanceof ServiceStopTest) {
            this.addOption("service.test.stop.timeout", (Option)new IntegerOption("Timeout", "service.test.stop.timeout", Integer.valueOf(-1), 10));
        }
    }

    public void removeOutputData() {
        File logfile = (File)this.getOptionValue(KEY_OPTION_LOGFILE);
        if (logfile != null) {
            logfile.delete();
            Utilities.deleteEmptyParents((File)logfile);
        }
    }

    public void doTest() throws Exception {
        this.doAction(this.getServiceAction());
    }

    protected abstract BridgeServiceAction getServiceAction();

    public void setServiceType(String serviceType) {
        this.addOption(KEY_OPTION_SERVICE_TYPE, (Option)new StringOption("Service Type", KEY_OPTION_SERVICE_TYPE, serviceType, 0));
    }

    protected String getServiceType() {
        Option option = this.getOption(KEY_OPTION_SERVICE_TYPE);
        if (option == null || option.getValue() == null) {
            return "E2E xUML Service";
        }
        return option.getValue().toString();
    }

    static {
        HttpsUtil.initialize();
    }
}

